/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.qualified.Qualified1;
import org.apache.cayenne.testdo.qualified.Qualified2;
import org.apache.cayenne.testdo.qualified.Qualified3;
import org.apache.cayenne.testdo.qualified.Qualified4;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-qualified.xml")
public class CDOQualifiedEntitiesIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tQualified1;
    private TableHelper tQualified2;
    private TableHelper tQualified3;
    private TableHelper tQualified4;

    @Before
    public void setUp() throws Exception {
        int bool = this.accessStackAdapter.supportsBoolean() ? 16 : 4;
        this.tQualified1 = new TableHelper(this.dbHelper, "TEST_QUALIFIED1").setColumns(new String[]{"ID", "NAME", "DELETED"}).setColumnTypes(new int[]{4, 12, bool});
        this.tQualified2 = new TableHelper(this.dbHelper, "TEST_QUALIFIED2").setColumns(new String[]{"ID", "NAME", "DELETED", "QUALIFIED1_ID"}).setColumnTypes(new int[]{4, 12, bool, 4});
        this.tQualified3 = new TableHelper(this.dbHelper, "TEST_QUALIFIED3").setColumns(new String[]{"ID", "NAME", "DELETED"}).setColumnTypes(new int[]{4, 12, bool});
        this.tQualified4 = new TableHelper(this.dbHelper, "TEST_QUALIFIED4").setColumns(new String[]{"ID", "NAME", "DELETED", "QUALIFIED3_ID"}).setColumnTypes(new int[]{4, 12, bool, 4});
    }

    private void createReadToManyDataSet() throws Exception {
        this.tQualified1.insert(new Object[]{1, "OX1", null});
        this.tQualified1.insert(new Object[]{2, "OX2", this.accessStackAdapter.supportsBoolean() ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1)});
        this.tQualified2.insert(new Object[]{1, "OY1", null, 1});
        this.tQualified2.insert(new Object[]{2, "OY2", this.accessStackAdapter.supportsBoolean() ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1), 1});
        this.tQualified2.insert(new Object[]{3, "OY3", null, 2});
        this.tQualified2.insert(new Object[]{4, "OY4", this.accessStackAdapter.supportsBoolean() ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1), 2});
    }

    private void createReadToOneDataSet() throws Exception {
        this.tQualified1.insert(new Object[]{1, "OX1", null});
        this.tQualified1.insert(new Object[]{2, "OX2", this.accessStackAdapter.supportsBoolean() ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1)});
        this.tQualified2.insert(new Object[]{1, "OY1", null, 2});
    }

    private void createJoinDataSet() throws Exception {
        this.tQualified3.insert(new Object[]{1, "O1", null});
        this.tQualified3.insert(new Object[]{2, "O2", this.accessStackAdapter.supportsBoolean() ? (Comparable<Boolean>)Boolean.valueOf(true) : (Comparable<Boolean>)Integer.valueOf(1)});
        this.tQualified4.insert(new Object[]{1, "SHOULD_SELECT", null, 1});
        this.tQualified4.insert(new Object[]{2, "SHOULD_NOT_SELECT", null, 2});
    }

    @Test
    public void testReadToMany() throws Exception {
        if (this.accessStackAdapter.supportsNullBoolean()) {
            this.createReadToManyDataSet();
            List roots = ObjectSelect.query(Qualified1.class).select(this.context);
            Assert.assertEquals((long)1L, (long)roots.size());
            Qualified1 root = (Qualified1)roots.get(0);
            Assert.assertEquals((Object)"OX1", (Object)root.getName());
            List<Qualified2> related = root.getQualified2s();
            Assert.assertEquals((long)1L, (long)related.size());
            Qualified2 r = related.get(0);
            Assert.assertEquals((Object)"OY1", (Object)r.getName());
        }
    }

    @Test
    public void testReadToOne() throws Exception {
        if (this.accessStackAdapter.supportsNullBoolean()) {
            this.createReadToOneDataSet();
            List roots = ObjectSelect.query(Qualified2.class).select(this.context);
            Assert.assertEquals((long)1L, (long)roots.size());
            Qualified2 root = (Qualified2)roots.get(0);
            Assert.assertEquals((Object)"OY1", (Object)root.getName());
            Qualified1 target = root.getQualified1();
            Assert.assertNull((Object)target);
        }
    }

    @Test
    public void joinWithQualifier() throws Exception {
        this.createJoinDataSet();
        List result = ObjectSelect.query(Qualified4.class).where(Qualified4.QUALIFIED3.dot(Qualified3.NAME).like("O%")).select(this.context);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"SHOULD_SELECT", (Object)((Qualified4)result.get(0)).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void joinWithCustomDbQualifier() throws Exception {
        this.createJoinDataSet();
        DbEntity entity1 = this.context.getEntityResolver().getDbEntity("TEST_QUALIFIED3");
        DbEntity entity2 = this.context.getEntityResolver().getDbEntity("TEST_QUALIFIED4");
        Expression oldExpression1 = entity1.getQualifier();
        Expression oldExpression2 = entity2.getQualifier();
        try {
            entity1.setQualifier(ExpressionFactory.matchDbExp("DELETED", null));
            entity2.setQualifier(ExpressionFactory.matchDbExp("DELETED", null));
            List result = ObjectSelect.query(Qualified4.class).where(Qualified4.QUALIFIED3.dot(Qualified3.NAME).like("O%")).select(this.context);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"SHOULD_SELECT", (Object)((Qualified4)result.get(0)).getName());
        }
        finally {
            entity1.setQualifier(oldExpression1);
            entity2.setQualifier(oldExpression2);
        }
    }
}

