/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.util.XMLEncoder;
import org.junit.Assert;
import org.junit.Test;

public class DbEntityTest {
    @Test
    public void testEncodeAsXML() {
        DbEntity entity = new DbEntity("X");
        entity.setSchema("s");
        entity.setCatalog("c");
        entity.addAttribute(new DbAttribute("a2", 12, entity));
        entity.addAttribute(new DbAttribute("a1", 4, entity));
        entity.addAttribute(new DbAttribute("a3", -5, entity));
        entity.addRelationship(new DbRelationship("r1"));
        StringWriter out = new StringWriter();
        XMLEncoder encoder = new XMLEncoder(new PrintWriter(out));
        entity.encodeAsXML(encoder, new EncoderDummyVisitor());
        String ls = System.lineSeparator();
        Assert.assertEquals((Object)("<db-entity name=\"X\" schema=\"s\" catalog=\"c\">" + ls + "<db-attribute name=\"a1\" type=\"INTEGER\"/>" + ls + "<db-attribute name=\"a2\" type=\"VARCHAR\"/>" + ls + "<db-attribute name=\"a3\" type=\"BIGINT\"/>" + ls + "</db-entity>" + ls), (Object)out.toString());
    }

    private class EncoderDummyVisitor
    extends BaseConfigurationNodeVisitor<Object> {
        private EncoderDummyVisitor() {
        }

        @Override
        public Object visitDbEntity(DbEntity entity) {
            return null;
        }

        @Override
        public Object visitDbAttribute(DbAttribute attribute) {
            return null;
        }

        @Override
        public Object visitDbRelationship(DbRelationship relationship) {
            return null;
        }
    }
}

