/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.translator.select.BaseColumnExtractorTest;
import org.apache.cayenne.access.translator.select.DbEntityColumnExtractor;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.ResultNodeDescriptor;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DbEntityColumnExtractorTest
extends BaseColumnExtractorTest {
    @Test
    public void testExtractNoPrefix() {
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(this.createMockDbEntity("mock")).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        DbEntityColumnExtractor extractor = new DbEntityColumnExtractor(context);
        extractor.extract(null);
        Assert.assertEquals((long)2L, (long)context.getResultNodeList().size());
        ResultNodeDescriptor descriptor0 = context.getResultNodeList().get(0);
        ResultNodeDescriptor descriptor1 = context.getResultNodeList().get(1);
        Assert.assertNull(descriptor0.getProperty());
        Assert.assertNotNull((Object)descriptor0.getNode());
        Assert.assertThat((Object)descriptor0.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor0.isAggregate());
        Assert.assertTrue((boolean)descriptor0.isInDataRow());
        Assert.assertEquals((Object)"id", (Object)descriptor0.getDataRowKey());
        Assert.assertNotNull((Object)descriptor0.getDbAttribute());
        Assert.assertEquals((long)-5L, (long)descriptor0.getJdbcType());
        Assert.assertNull(descriptor1.getProperty());
        Assert.assertNotNull((Object)descriptor1.getNode());
        Assert.assertThat((Object)descriptor1.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor1.isAggregate());
        Assert.assertTrue((boolean)descriptor1.isInDataRow());
        Assert.assertNotNull((Object)descriptor1.getDbAttribute());
        Assert.assertEquals((Object)"name", (Object)descriptor1.getDataRowKey());
        Assert.assertEquals((long)-3L, (long)descriptor1.getJdbcType());
        Assert.assertEquals((Object)"byte[]", (Object)descriptor1.getJavaType());
    }

    @Test
    public void testExtractWithPrefix() {
        DbEntity mockDbEntity = this.createMockDbEntity("mock1");
        DbEntity mock2DbEntity = this.createMockDbEntity("mock2");
        DataMap dataMap = new DataMap();
        dataMap.addDbEntity(mockDbEntity);
        dataMap.addDbEntity(mock2DbEntity);
        mockDbEntity.setDataMap(dataMap);
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withMetaData(new MockQueryMetadataBuilder().withDbEntity(mockDbEntity).build()).build();
        MockTranslatorContext context = new MockTranslatorContext(wrapper);
        DbRelationship relationship = new DbRelationship();
        relationship.setSourceEntity(mockDbEntity);
        relationship.setTargetEntityName("mock1");
        context.getTableTree().addJoinTable("prefix", relationship, JoinType.INNER);
        DbEntityColumnExtractor extractor = new DbEntityColumnExtractor(context);
        extractor.extract("prefix");
        Assert.assertEquals((long)2L, (long)context.getResultNodeList().size());
        ResultNodeDescriptor descriptor0 = context.getResultNodeList().get(0);
        ResultNodeDescriptor descriptor1 = context.getResultNodeList().get(1);
        Assert.assertNull(descriptor0.getProperty());
        Assert.assertNotNull((Object)descriptor0.getNode());
        Assert.assertThat((Object)descriptor0.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor0.isAggregate());
        Assert.assertTrue((boolean)descriptor0.isInDataRow());
        Assert.assertEquals((Object)"prefix.id", (Object)descriptor0.getDataRowKey());
        Assert.assertNotNull((Object)descriptor0.getDbAttribute());
        Assert.assertEquals((long)-5L, (long)descriptor0.getJdbcType());
        Assert.assertNull(descriptor1.getProperty());
        Assert.assertNotNull((Object)descriptor1.getNode());
        Assert.assertThat((Object)descriptor1.getNode(), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertFalse((boolean)descriptor1.isAggregate());
        Assert.assertTrue((boolean)descriptor1.isInDataRow());
        Assert.assertNotNull((Object)descriptor1.getDbAttribute());
        Assert.assertEquals((Object)"prefix.name", (Object)descriptor1.getDataRowKey());
        Assert.assertEquals((long)-3L, (long)descriptor1.getJdbcType());
    }
}

