/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Date;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowUtils;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataRowUtilsIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
    }

    protected void createOneArtist() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
    }

    protected void createOneArtistAndOnePainting() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tPainting.insert(new Object[]{6, "p_artist2", 11, 1000});
    }

    @Test
    public void testMerge() throws Exception {
        this.createOneArtist();
        String n1 = "changed";
        String n2 = "changed again";
        Artist a1 = (Artist)ObjectSelect.query(Artist.class).select(this.context).get(0);
        a1.setArtistName(n1);
        DataRow s2 = new DataRow(2);
        s2.put("ARTIST_NAME", n2);
        s2.put("DATE_OF_BIRTH", new Date());
        ClassDescriptor d = this.context.getEntityResolver().getClassDescriptor("Artist");
        DataRowUtils.mergeObjectWithSnapshot(this.context, d, a1, s2);
        Assert.assertEquals((Object)n1, (Object)a1.getArtistName());
        Assert.assertEquals(s2.get("DATE_OF_BIRTH"), (Object)a1.getDateOfBirth());
    }

    @Test
    public void testIsToOneTargetModified() throws Exception {
        this.createOneArtist();
        ClassDescriptor d = this.context.getEntityResolver().getClassDescriptor("Painting");
        ArcProperty toArtist = (ArcProperty)d.getProperty("toArtist");
        Artist artist2 = ObjectSelect.query(Artist.class).selectFirst(this.context);
        Painting painting = this.context.newObject(Painting.class);
        painting.setPaintingTitle("PX");
        painting.setToArtist(artist2);
        this.context.commitChanges();
        this.tArtist.insert(new Object[]{119, "artist3"});
        Artist artist3 = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist3")).selectFirst(this.context);
        Assert.assertNotSame((Object)artist3, (Object)painting.getToArtist());
        ObjectDiff diff = this.context.getObjectStore().registerDiff(painting.getObjectId(), null);
        Assert.assertFalse((boolean)DataRowUtils.isToOneTargetModified(toArtist, painting, diff));
        painting.setToArtist(artist3);
        Assert.assertTrue((boolean)DataRowUtils.isToOneTargetModified(toArtist, painting, diff));
    }

    @Test
    public void testIsToOneTargetModifiedWithNewTarget() throws Exception {
        this.createOneArtistAndOnePainting();
        List paintings = ObjectSelect.query(Painting.class).select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Painting p1 = (Painting)paintings.get(0);
        ClassDescriptor d = this.context.getEntityResolver().getClassDescriptor("Painting");
        ArcProperty toGallery = (ArcProperty)d.getProperty("toGallery");
        ObjectDiff diff = this.context.getObjectStore().registerDiff(p1.getObjectId(), null);
        Assert.assertFalse((boolean)DataRowUtils.isToOneTargetModified(toGallery, p1, diff));
        Gallery g1 = (Gallery)this.context.newObject("Gallery");
        g1.addToPaintingArray(p1);
        Assert.assertTrue((boolean)DataRowUtils.isToOneTargetModified(toGallery, p1, diff));
    }
}

