/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.ExternalTransaction;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPerformQueryAPIIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context2;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    @Inject
    private JdbcEventLogger jdbcEventLogger;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    private void createTwoArtists() throws Exception {
        this.tArtist.insert(new Object[]{21, "artist2"});
        this.tArtist.insert(new Object[]{201, "artist3"});
    }

    private void createTwoArtistsAndTwoPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tPainting.insert(new Object[]{6, 101, "p_artist3", 1000});
        this.tPainting.insert(new Object[]{7, 11, "p_artist2", 2000});
    }

    @Test
    public void testObjectQueryStringBoolean() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        List<?> paintings = this.context.performQuery("ObjectQuery", true);
        Assert.assertNotNull(paintings);
        Assert.assertEquals((long)2L, (long)paintings.size());
    }

    @Test
    public void testObjectQueryStringMapBoolean() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, 11);
        Map<String, Artist> parameters = Collections.singletonMap("artist", a);
        List<?> paintings = this.context2.performQuery("ObjectQuery", parameters, true);
        Assert.assertNotNull(paintings);
        Assert.assertEquals((long)1L, (long)paintings.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcedureQueryStringMapBoolean() throws Exception {
        List<?> artists;
        if (!this.accessStackAdapter.supportsStoredProcedures()) {
            return;
        }
        if (!this.accessStackAdapter.canMakeObjectsOutOfProcedures()) {
            return;
        }
        this.createTwoArtistsAndTwoPaintingsDataSet();
        Map<String, String> parameters = Collections.singletonMap("aName", "artist2");
        ExternalTransaction t = new ExternalTransaction(this.jdbcEventLogger);
        BaseTransaction.bindThreadTransaction(t);
        try {
            artists = this.context.performQuery("ProcedureQuery", parameters, true);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            t.commit();
        }
        Assert.assertNotNull(artists);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist artist = (Artist)artists.get(0);
        Assert.assertEquals((long)11L, (long)((Number)artist.getObjectId().getIdSnapshot().get("ARTIST_ID")).intValue());
    }

    @Test
    public void testNonSelectingQueryString() throws Exception {
        int[] counts = this.context.performNonSelectingQuery("NonSelectingQuery");
        Assert.assertNotNull((Object)counts);
        Assert.assertEquals((long)1L, (long)counts.length);
        Assert.assertEquals((long)1L, (long)counts[0]);
        Painting p = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 512);
        Assert.assertEquals((Object)"No Painting Like This", (Object)p.getPaintingTitle());
    }

    @Test
    public void testNonSelectingQueryStringMap() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", 300);
        parameters.put("title", "Go Figure");
        parameters.put("price", new BigDecimal("22.01"));
        int[] counts = this.context.performNonSelectingQuery("ParameterizedNonSelectingQuery", parameters);
        Assert.assertNotNull((Object)counts);
        Assert.assertEquals((long)1L, (long)counts.length);
        Assert.assertEquals((long)1L, (long)counts[0]);
        Painting p = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 300);
        Assert.assertEquals((Object)"Go Figure", (Object)p.getPaintingTitle());
    }

    @Test
    public void testPerfomQueryNonSelecting() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("aa");
        this.context.commitChanges();
        SQLTemplate q = new SQLTemplate(Artist.class, "DELETE FROM ARTIST");
        List result = this.context.performQuery(q);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testObjectQueryWithLocalCache() throws Exception {
        this.createTwoArtists();
        List<?> artists = this.context.performQuery("QueryWithLocalCache", true);
        Assert.assertEquals((long)2L, (long)artists.size());
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            List<?> artists1 = this.context.performQuery("QueryWithLocalCache", false);
            Assert.assertEquals((long)2L, (long)artists1.size());
        });
    }

    @Test
    public void testObjectQueryWithSharedCache() throws Exception {
        this.createTwoArtists();
        List<?> artists = this.context.performQuery("QueryWithSharedCache", true);
        Assert.assertEquals((long)2L, (long)artists.size());
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            List<?> artists1 = this.context2.performQuery("QueryWithSharedCache", false);
            Assert.assertEquals((long)2L, (long)artists1.size());
        });
    }
}

