/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.lazy.Lazyblob;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lazy-attributes.xml")
public class LazyAttributesIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void setup() throws Exception {
        TableHelper th = new TableHelper(this.dbHelper, "LAZYBLOB").setColumns(new String[]{"ID", "NAME", "LAZY_DATA"}).setColumnTypes(new int[]{4, 12, -3});
        th.insert(new Object[]{1, "test", new byte[]{1, 2, 3, 4, 5}});
    }

    @Test
    public void testRead() {
        Lazyblob lazyblob = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        byte[] expected = new byte[]{1, 2, 3, 4, 5};
        Assert.assertThat((Object)lazyblob.readPropertyDirectly("lazyData"), (Matcher)CoreMatchers.instanceOf(Fault.class));
        Assert.assertArrayEquals((byte[])expected, (byte[])((byte[])lazyblob.readProperty("lazyData")));
        Assert.assertArrayEquals((byte[])expected, (byte[])lazyblob.getLazyData());
    }

    @Test
    public void testReadColumn() {
        byte[] lazyData = (byte[])ObjectSelect.columnQuery(Lazyblob.class, Lazyblob.LAZY_DATA).selectOne(this.context);
        byte[] expected = new byte[]{1, 2, 3, 4, 5};
        Assert.assertArrayEquals((byte[])expected, (byte[])lazyData);
    }

    @Test
    public void testWrite() {
        Lazyblob lazyblob = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        byte[] expected = new byte[]{5, 4, 3, 2, 1};
        lazyblob.setLazyData(expected);
        this.context.commitChanges();
        Assert.assertThat((Object)lazyblob.readPropertyDirectly("lazyData"), (Matcher)CoreMatchers.instanceOf(byte[].class));
        Assert.assertArrayEquals((byte[])expected, (byte[])((byte[])lazyblob.readProperty("lazyData")));
        Assert.assertArrayEquals((byte[])expected, (byte[])lazyblob.getLazyData());
        Lazyblob lazyblob2 = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        Assert.assertArrayEquals((byte[])expected, (byte[])lazyblob2.getLazyData());
    }

    @Test
    public void testUpdateNoFetch() {
        Lazyblob lazyblob = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        lazyblob.setName("updated_name");
        this.context.commitChanges();
        Lazyblob lazyblob2 = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        Assert.assertEquals((Object)"updated_name", (Object)lazyblob2.getName());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])lazyblob2.getLazyData());
    }

    @Test
    public void testUpdateFetch() {
        Lazyblob lazyblob = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        lazyblob.setName("updated_name");
        lazyblob.getLazyData();
        this.context.commitChanges();
        Lazyblob lazyblob2 = (Lazyblob)ObjectSelect.query(Lazyblob.class).selectOne(this.context);
        Assert.assertEquals((Object)"updated_name", (Object)lazyblob2.getName());
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5}, (byte[])lazyblob2.getLazyData());
    }
}

