/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.frontbase;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.frontbase.FrontBaseBooleanType;
import org.apache.cayenne.dba.frontbase.FrontBaseByteArrayType;
import org.apache.cayenne.dba.frontbase.FrontBaseCharType;
import org.apache.cayenne.dba.frontbase.FrontBasePkGenerator;
import org.apache.cayenne.dba.frontbase.FrontBaseSQLTreeProcessor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.resource.ResourceLocator;

public class FrontBaseAdapter
extends JdbcAdapter {
    public FrontBaseAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return new FrontBaseSQLTreeProcessor();
    }

    @Override
    public String tableTypeForTable() {
        return "BASE TABLE";
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new FrontBaseByteArrayType());
        map.registerType(new FrontBaseBooleanType());
        map.registerType(new FrontBaseCharType());
    }

    @Override
    public String createTable(DbEntity ent) {
        QuotingStrategy context = this.getQuotingStrategy();
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ");
        buf.append(context.quotedFullyQualifiedName(ent));
        buf.append(" (");
        Iterator<DbAttribute> it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            int len;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '%s.%s'.", ent.getFullyQualifiedName(), at.getName());
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '%s.%s': %s", ent.getFullyQualifiedName(), at.getName(), at.getType());
            }
            String type = types[0];
            buf.append(context.quotedName(at)).append(' ').append(type);
            if (at.getType() == -1) {
                len = at.getMaxLength() > 0 ? at.getMaxLength() : 0x40000000;
                buf.append("(").append(len).append(")");
            } else if (at.getType() == -3 || at.getType() == -2) {
                len = at.getMaxLength() > 0 ? at.getMaxLength() : 0x40000000;
                buf.append("(").append(len *= 8).append(")");
            } else if (this.typeSupportsLength(at.getType())) {
                int scale;
                len = at.getMaxLength();
                int n = scale = TypesMapping.isDecimal(at.getType()) ? at.getScale() : -1;
                if (scale > len) {
                    scale = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (scale >= 0) {
                        buf.append(", ").append(scale);
                    }
                    buf.append(')');
                }
            }
            if (!at.isMandatory()) continue;
            buf.append(" NOT NULL");
        }
        Iterator<DbAttribute> pkit = ent.getPrimaryKeys().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = pkit.next();
                buf.append(this.quotingStrategy.quotedName(at));
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Collections.singleton("DROP TABLE " + this.getQuotingStrategy().quotedFullyQualifiedName(table) + " CASCADE");
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new FrontBasePkGenerator(this);
    }
}

