/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.util.ArrayUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilTest {
    @Test
    public void sliceIntArray() {
        int[] array = new int[]{1, 2, 3, 4, 5, 6, 7};
        int[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])result[0]);
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])result[1]);
        Assert.assertArrayEquals((int[])new int[]{5, 6}, (int[])result[2]);
        Assert.assertArrayEquals((int[])new int[]{7}, (int[])result[3]);
        int[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result2[0]);
        Assert.assertArrayEquals((int[])new int[]{5, 6, 7}, (int[])result2[1]);
        int[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((int[])array, (int[])result3[0]);
        int[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((int[])array, (int[])result4[0]);
        int[] array2 = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        int[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result5[0]);
        Assert.assertArrayEquals((int[])new int[]{5, 6, 7, 8}, (int[])result5[1]);
    }

    @Test
    public void sliceLongArray() {
        long[] array = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L};
        long[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L}, (long[])result[0]);
        Assert.assertArrayEquals((long[])new long[]{3L, 4L}, (long[])result[1]);
        Assert.assertArrayEquals((long[])new long[]{5L, 6L}, (long[])result[2]);
        Assert.assertArrayEquals((long[])new long[]{7L}, (long[])result[3]);
        long[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L}, (long[])result2[0]);
        Assert.assertArrayEquals((long[])new long[]{5L, 6L, 7L}, (long[])result2[1]);
        long[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((long[])array, (long[])result3[0]);
        long[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((long[])array, (long[])result4[0]);
        long[] array2 = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L};
        long[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L}, (long[])result5[0]);
        Assert.assertArrayEquals((long[])new long[]{5L, 6L, 7L, 8L}, (long[])result5[1]);
    }

    @Test
    public void sliceFloatArray() {
        float[] array = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f};
        float[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 2.0f}, (float[])result[0], (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{3.0f, 4.0f}, (float[])result[1], (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{5.0f, 6.0f}, (float[])result[2], (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{7.0f}, (float[])result[3], (float)1.0E-6f);
        float[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f}, (float[])result2[0], (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{5.0f, 6.0f, 7.0f}, (float[])result2[1], (float)1.0E-6f);
        float[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((float[])array, (float[])result3[0], (float)1.0E-6f);
        float[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((float[])array, (float[])result4[0], (float)1.0E-6f);
        float[] array2 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        float[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f}, (float[])result5[0], (float)1.0E-6f);
        Assert.assertArrayEquals((float[])new float[]{5.0f, 6.0f, 7.0f, 8.0f}, (float[])result5[1], (float)1.0E-6f);
    }

    @Test
    public void sliceDoubleArray() {
        double[] array = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
        double[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0}, (double[])result[0], (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{3.0, 4.0}, (double[])result[1], (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{5.0, 6.0}, (double[])result[2], (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{7.0}, (double[])result[3], (double)1.0E-6);
        double[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 4.0}, (double[])result2[0], (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{5.0, 6.0, 7.0}, (double[])result2[1], (double)1.0E-6);
        double[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((double[])array, (double[])result3[0], (double)1.0E-6);
        double[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((double[])array, (double[])result4[0], (double)1.0E-6);
        double[] array2 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 4.0}, (double[])result5[0], (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{5.0, 6.0, 7.0, 8.0}, (double[])result5[1], (double)1.0E-6);
    }

    @Test
    public void sliceCharArray() {
        char[] array = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007'};
        char[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0002'}, (char[])result[0]);
        Assert.assertArrayEquals((char[])new char[]{'\u0003', '\u0004'}, (char[])result[1]);
        Assert.assertArrayEquals((char[])new char[]{'\u0005', '\u0006'}, (char[])result[2]);
        Assert.assertArrayEquals((char[])new char[]{'\u0007'}, (char[])result[3]);
        char[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, (char[])result2[0]);
        Assert.assertArrayEquals((char[])new char[]{'\u0005', '\u0006', '\u0007'}, (char[])result2[1]);
        char[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((char[])array, (char[])result3[0]);
        char[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((char[])array, (char[])result4[0]);
        char[] array2 = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b'};
        char[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((char[])new char[]{'\u0001', '\u0002', '\u0003', '\u0004'}, (char[])result5[0]);
        Assert.assertArrayEquals((char[])new char[]{'\u0005', '\u0006', '\u0007', '\b'}, (char[])result5[1]);
    }

    @Test
    public void sliceShortArray() {
        short[] array = new short[]{1, 2, 3, 4, 5, 6, 7};
        short[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((short[])new short[]{1, 2}, (short[])result[0]);
        Assert.assertArrayEquals((short[])new short[]{3, 4}, (short[])result[1]);
        Assert.assertArrayEquals((short[])new short[]{5, 6}, (short[])result[2]);
        Assert.assertArrayEquals((short[])new short[]{7}, (short[])result[3]);
        short[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((short[])new short[]{1, 2, 3, 4}, (short[])result2[0]);
        Assert.assertArrayEquals((short[])new short[]{5, 6, 7}, (short[])result2[1]);
        short[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((short[])array, (short[])result3[0]);
        short[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((short[])array, (short[])result4[0]);
        short[] array2 = new short[]{1, 2, 3, 4, 5, 6, 7, 8};
        short[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((short[])new short[]{1, 2, 3, 4}, (short[])result5[0]);
        Assert.assertArrayEquals((short[])new short[]{5, 6, 7, 8}, (short[])result5[1]);
    }

    @Test
    public void sliceByteArray() {
        byte[] array = new byte[]{1, 2, 3, 4, 5, 6, 7};
        byte[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])result[0]);
        Assert.assertArrayEquals((byte[])new byte[]{3, 4}, (byte[])result[1]);
        Assert.assertArrayEquals((byte[])new byte[]{5, 6}, (byte[])result[2]);
        Assert.assertArrayEquals((byte[])new byte[]{7}, (byte[])result[3]);
        byte[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])result2[0]);
        Assert.assertArrayEquals((byte[])new byte[]{5, 6, 7}, (byte[])result2[1]);
        byte[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((byte[])array, (byte[])result3[0]);
        byte[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((byte[])array, (byte[])result4[0]);
        byte[] array2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])result5[0]);
        Assert.assertArrayEquals((byte[])new byte[]{5, 6, 7, 8}, (byte[])result5[1]);
    }

    @Test
    public void sliceBooleanArray() {
        boolean[] array = new boolean[]{true, true, false, true, false, false, true};
        boolean[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])result[0]);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])result[1]);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, false}, (boolean[])result[2]);
        Assert.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])result[3]);
        boolean[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((boolean[])new boolean[]{true, true, false, true}, (boolean[])result2[0]);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, false, true}, (boolean[])result2[1]);
        boolean[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((boolean[])array, (boolean[])result3[0]);
        boolean[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((boolean[])array, (boolean[])result4[0]);
        boolean[] array2 = new boolean[]{true, true, false, true, false, false, true, false};
        boolean[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((boolean[])new boolean[]{true, true, false, true}, (boolean[])result5[0]);
        Assert.assertArrayEquals((boolean[])new boolean[]{false, false, true, false}, (boolean[])result5[1]);
    }

    @Test
    public void sliceObjectArray() {
        Object[] array = new Object[]{1, 2, 3, 4, 5, 6, 7};
        Object[][] result = ArrayUtil.sliceArray(array, 2);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((Object[])new Object[]{1, 2}, (Object[])result[0]);
        Assert.assertArrayEquals((Object[])new Object[]{3, 4}, (Object[])result[1]);
        Assert.assertArrayEquals((Object[])new Object[]{5, 6}, (Object[])result[2]);
        Assert.assertArrayEquals((Object[])new Object[]{7}, (Object[])result[3]);
        Object[][] result2 = ArrayUtil.sliceArray(array, 4);
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, 3, 4}, (Object[])result2[0]);
        Assert.assertArrayEquals((Object[])new Object[]{5, 6, 7}, (Object[])result2[1]);
        Object[][] result3 = ArrayUtil.sliceArray(array, 7);
        Assert.assertEquals((long)1L, (long)result3.length);
        Assert.assertArrayEquals((Object[])array, (Object[])result3[0]);
        Object[][] result4 = ArrayUtil.sliceArray(array, 10);
        Assert.assertEquals((long)1L, (long)result4.length);
        Assert.assertArrayEquals((Object[])array, (Object[])result4[0]);
        Object[] array2 = new Object[]{1, 2, 3, 4, 5, 6, 7, 8};
        Object[][] result5 = ArrayUtil.sliceArray(array2, 4);
        Assert.assertEquals((long)2L, (long)result5.length);
        Assert.assertArrayEquals((Object[])new Object[]{1, 2, 3, 4}, (Object[])result5[0]);
        Assert.assertArrayEquals((Object[])new Object[]{5, 6, 7, 8}, (Object[])result5[1]);
    }
}

