/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.reflect.PojoMapper;
import org.junit.Assert;
import org.junit.Test;

public class PojoMapperTest {
    @Test
    public void testObjectCreation() {
        PojoMapper<C1> descriptor = new PojoMapper<C1>(C1.class);
        Object o = new Object();
        Object[] data = new Object[]{"123", o, 42};
        C1 object = descriptor.apply(data);
        Assert.assertEquals((Object)"123", (Object)object.a);
        Assert.assertSame((Object)o, (Object)object.b);
        Assert.assertEquals((long)42L, (long)object.c);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testNonPublicClass() {
        new PojoMapper<C2>(C2.class);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testNonPublicConstructor() {
        new PojoMapper<C3>(C3.class);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testNonDefaultConstructor() {
        new PojoMapper<C4>(C4.class);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testWrongArgumentCount() {
        PojoMapper<C1> descriptor = new PojoMapper<C1>(C1.class);
        Object[] data = new Object[]{"123", new Object(), 42, 32};
        descriptor.apply(data);
    }

    public static class C4 {
        int a;

        public C4(int a) {
        }
    }

    public static class C3 {
        int a;

        private C3() {
        }
    }

    private static class C2 {
        int a;

        private C2() {
        }
    }

    public static class C1 {
        String a;
        Object b;
        int c;
    }
}

