/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.inheritance_with_enum.Dependent;
import org.apache.cayenne.testdo.inheritance_with_enum.Root;
import org.apache.cayenne.testdo.inheritance_with_enum.Sub;
import org.apache.cayenne.testdo.inheritance_with_enum.Type;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-inheritance-with-enum.xml")
public class QueryWithInheritancePrefetchIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private DataChannelInterceptor queryInterceptor;

    @Before
    public void createTestData() throws Exception {
        TableHelper tRoot = new TableHelper(this.dbHelper, "iwe_root");
        tRoot.setColumns(new String[]{"id", "type", "name", "enum"});
        tRoot.insert(new Object[]{1, 0, "root1", null});
        tRoot.insert(new Object[]{2, 1, "enum1", Type.type1.ordinal()});
        tRoot.insert(new Object[]{3, 1, "enum2", Type.type2.ordinal()});
        TableHelper tDependent = new TableHelper(this.dbHelper, "iwe_dependent");
        tDependent.setColumns(new String[]{"id", "root_id", "name"});
        tDependent.insert(new Object[]{1, 1, "test1"});
        tDependent.insert(new Object[]{2, 2, "test2"});
        tDependent.insert(new Object[]{3, 3, "test3"});
    }

    @Test
    public void directQuery() {
        List result = ObjectSelect.query(Root.class).orderBy("db:id").select(this.runtime.newContext());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertNotNull(result.get(0));
        Assert.assertFalse((boolean)(result.get(0) instanceof Sub));
        Assert.assertTrue((boolean)(result.get(1) instanceof Sub));
        Assert.assertTrue((boolean)(result.get(2) instanceof Sub));
        Assert.assertEquals((Object)((Object)Type.type1), (Object)((Object)((Sub)result.get(1)).getEnum()));
        Assert.assertEquals((Object)((Object)Type.type2), (Object)((Object)((Sub)result.get(2)).getEnum()));
    }

    @Test
    public void queryWithJointPrefetch() {
        List<Dependent> result = ObjectSelect.query(Dependent.class).orderBy("db:id").prefetch(Dependent.ROOT.joint()).select(this.runtime.newContext());
        this.assertPrefetchResult(result);
    }

    @Test
    public void queryWithDisjointPrefetch() {
        List<Dependent> result = ObjectSelect.query(Dependent.class).orderBy("db:id").prefetch(Dependent.ROOT.disjoint()).select(this.runtime.newContext());
        this.assertPrefetchResult(result);
    }

    @Test
    public void queryWithDisjointByIdPrefetch() {
        List<Dependent> result = ObjectSelect.query(Dependent.class).orderBy("db:id").prefetch(Dependent.ROOT.disjointById()).select(this.runtime.newContext());
        this.assertPrefetchResult(result);
    }

    private void assertPrefetchResult(List<Dependent> result) {
        Assert.assertEquals((long)3L, (long)result.size());
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertNotNull((Object)((Dependent)result.get(0)).getRoot());
            Assert.assertFalse((boolean)(((Dependent)result.get(0)).getRoot() instanceof Sub));
            Assert.assertTrue((boolean)(((Dependent)result.get(1)).getRoot() instanceof Sub));
            Assert.assertTrue((boolean)(((Dependent)result.get(2)).getRoot() instanceof Sub));
            Assert.assertEquals((Object)((Object)Type.type1), (Object)((Object)((Sub)((Dependent)result.get(1)).getRoot()).getEnum()));
            Assert.assertEquals((Object)((Object)Type.type2), (Object)((Object)((Sub)((Dependent)result.get(2)).getRoot()).getEnum()));
        });
    }
}

