/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.MappedSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLExec;
import org.apache.cayenne.query.SQLSelect;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class QueryTimeoutIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testObjectSelect() {
        ObjectSelect<Artist> objectSelect = ObjectSelect.query(Artist.class).queryTimeout(10);
        Assert.assertEquals((long)10L, (long)objectSelect.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        objectSelect.select(this.context);
    }

    @Test
    public void testSQLTemplate() {
        SQLTemplate sqlTemplate = new SQLTemplate();
        sqlTemplate.setDefaultTemplate("SELECT * FROM ARTIST");
        sqlTemplate.setQueryTimeout(10);
        Assert.assertEquals((long)10L, (long)sqlTemplate.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        this.context.performQuery(sqlTemplate);
    }

    @Test
    public void testColumnSelect() {
        ColumnSelect columnSelect = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).queryTimeout(10);
        Assert.assertEquals((long)10L, (long)columnSelect.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        this.context.performQuery(columnSelect);
    }

    @Test
    public void testEjbql() {
        EJBQLQuery ejbqlQuery = new EJBQLQuery("select a from Artist a");
        ejbqlQuery.setQueryTimeout(10);
        Assert.assertEquals((long)10L, (long)ejbqlQuery.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        this.context.performQuery(ejbqlQuery);
    }

    @Test
    public void testSqlSelect() {
        SQLSelect<Artist> sqlSelect = SQLSelect.query(Artist.class, "SELECT * FROM ARTIST").queryTimeout(10);
        Assert.assertEquals((long)10L, (long)sqlSelect.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        this.context.performQuery(sqlSelect);
    }

    @Test
    public void testSqlExec() {
        SQLExec sqlExec = SQLExec.query("SELECT * FROM ARTIST").queryTimeout(10);
        Assert.assertEquals((long)10L, (long)sqlExec.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        this.context.performQuery(sqlExec);
    }

    @Test
    public void testMappedSelect() {
        MappedSelect<Artist> mappedSelect = MappedSelect.query("SelectTestUpper", Artist.class).queryTimeout(10);
        Query replacementQuery = mappedSelect.createReplacementQuery(this.context.getEntityResolver());
        Assert.assertEquals((long)10L, (long)replacementQuery.getMetaData(this.context.getEntityResolver()).getQueryTimeout());
        this.context.performQuery(replacementQuery);
    }
}

