/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.UpdateBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.UpdateNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class UpdateBuilderTest {
    @Test
    public void testUpdate() {
        UpdateBuilder builder = new UpdateBuilder("test");
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(UpdateNode.class));
        this.assertSQL("UPDATE test", node);
    }

    @Test
    public void testUpdateWithFields() {
        UpdateBuilder builder = new UpdateBuilder("test");
        builder.set(SQLBuilder.column("col1").eq(SQLBuilder.value(1))).set(SQLBuilder.column("col2").eq(SQLBuilder.value("test"))).set(SQLBuilder.column("col3").eq(SQLBuilder.value(null)));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(UpdateNode.class));
        this.assertSQL("UPDATE test SET col1 = 1, col2 = 'test', col3 = NULL", node);
    }

    @Test
    public void testUpdateWithWhere() {
        UpdateBuilder builder = new UpdateBuilder("test");
        builder.set(SQLBuilder.column("col1").eq(SQLBuilder.value(1))).where(SQLBuilder.column("id").eq(SQLBuilder.value(123L)));
        Node node = builder.build();
        Assert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(UpdateNode.class));
        this.assertSQL("UPDATE test SET col1 = 1 WHERE id = 123", node);
    }

    private void assertSQL(String expected, Node node) {
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(new StringBuilderAppendable());
        node.visit(visitor);
        Assert.assertEquals((Object)expected, (Object)visitor.getSQLString());
    }
}

