/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextPrefetchIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tPaintingInfo;
    protected TableHelper tExhibit;
    protected TableHelper tGallery;
    protected TableHelper tArtistExhibit;
    protected TableHelper tArtistGroup;
    protected TableHelper tArtGroup;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE", "GALLERY_ID"}).setColumnTypes(new int[]{4, 12, -5, 3, 4});
        this.tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        this.tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "OPENING_DATE", "CLOSING_DATE"});
        this.tArtistExhibit = new TableHelper(this.dbHelper, "ARTIST_EXHIBIT");
        this.tArtistExhibit.setColumns(new String[]{"ARTIST_ID", "EXHIBIT_ID"});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tArtistGroup = new TableHelper(this.dbHelper, "ARTIST_GROUP");
        this.tArtistGroup.setColumns(new String[]{"ARTIST_ID", "GROUP_ID"});
        this.tArtGroup = new TableHelper(this.dbHelper, "ARTGROUP");
        this.tArtGroup.setColumns(new String[]{"GROUP_ID", "NAME"});
    }

    protected void createTwoArtistsAndTwoPaintingsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tPainting.insert(new Object[]{6, "p_artist3", 101, 1000, null});
        this.tPainting.insert(new Object[]{7, "p_artist2", 11, 2000, null});
    }

    protected void createArtistWithTwoPaintingsAndTwoInfosDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tPainting.insert(new Object[]{6, "p_artist2", 11, 1000, null});
        this.tPainting.insert(new Object[]{7, "p_artist3", 11, 2000, null});
        this.tPaintingInfo.insert(new Object[]{6, "xYs"});
    }

    protected void createTwoArtistsWithExhibitsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tGallery.insert(new Object[]{25, "gallery1"});
        this.tGallery.insert(new Object[]{31, "gallery2"});
        this.tGallery.insert(new Object[]{45, "gallery3"});
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.tExhibit.insert(new Object[]{1, 25, now, now});
        this.tExhibit.insert(new Object[]{2, 31, now, now});
        this.tExhibit.insert(new Object[]{3, 45, now, now});
        this.tExhibit.insert(new Object[]{4, 25, now, now});
        this.tArtistExhibit.insert(new Object[]{11, 2});
        this.tArtistExhibit.insert(new Object[]{11, 4});
        this.tArtistExhibit.insert(new Object[]{101, 1});
        this.tArtistExhibit.insert(new Object[]{101, 3});
        this.tArtistExhibit.insert(new Object[]{101, 4});
    }

    private void createArtistWithPaintingAndGallery() throws SQLException {
        this.tArtist.insert(new Object[]{1, "artist1"});
        this.tGallery.insert(new Object[]{1, "gallery1"});
        this.tPainting.insert(new Object[]{1, "painting1", 1, 100, 1});
    }

    @Test
    public void testPrefetchToMany_ViaPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).prefetch("paintingArray", 0);
        List artists = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)artists.size());
            for (int i = 0; i < 2; ++i) {
                Artist a = (Artist)artists.get(i);
                List toMany = (List)a.readPropertyDirectly("paintingArray");
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)1L, (long)toMany.size());
                Painting p = (Painting)toMany.get(0);
                Assert.assertEquals((String)("Invalid prefetched painting:" + p), (Object)("p_" + a.getArtistName()), (Object)p.getPaintingTitle());
            }
        });
    }

    @Test
    public void testPrefetchToMany_WithQualfier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name1", "artist2");
        params.put("name2", "artist3");
        Expression e = ExpressionFactory.exp("artistName = $name1 or artistName = $name2", new Object[0]);
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(e.params(params)).prefetch(Artist.PAINTING_ARRAY.disjoint());
        List artists = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)artists.size());
            Artist a1 = (Artist)artists.get(0);
            List toMany = (List)a1.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertNotNull((Object)toMany);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
            Assert.assertEquals((long)1L, (long)toMany.size());
            Painting p1 = (Painting)toMany.get(0);
            Assert.assertEquals((Object)("p_" + a1.getArtistName()), (Object)p1.getPaintingTitle());
            Artist a2 = (Artist)artists.get(1);
            List toMany2 = (List)a2.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertNotNull((Object)toMany2);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
            Assert.assertEquals((long)1L, (long)toMany2.size());
            Painting p2 = (Painting)toMany2.get(0);
            Assert.assertEquals((Object)("p_" + a2.getArtistName()), (Object)p2.getPaintingTitle());
        });
    }

    @Test
    public void testPrefetchToManyNoQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint());
        List artists = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)artists.size());
            for (int i = 0; i < 2; ++i) {
                Artist a = (Artist)artists.get(i);
                List toMany = (List)a.readPropertyDirectly("paintingArray");
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)1L, (long)toMany.size());
                Painting p = (Painting)toMany.get(0);
                Assert.assertEquals((String)("Invalid prefetched painting:" + p), (Object)("p_" + a.getArtistName()), (Object)p.getPaintingTitle());
            }
        });
    }

    @Test
    public void testPrefetchByPathToManyNoQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        List artists = ObjectSelect.query(Artist.class).prefetch("paintingArray", 1).select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)artists.size());
            for (int i = 0; i < 2; ++i) {
                Artist a = (Artist)artists.get(i);
                List toMany = (List)a.readPropertyDirectly("paintingArray");
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
                Assert.assertEquals((long)1L, (long)toMany.size());
                Painting p = (Painting)toMany.get(0);
                Assert.assertEquals((String)("Invalid prefetched painting:" + p), (Object)("p_" + a.getArtistName()), (Object)p.getPaintingTitle());
            }
        });
    }

    @Test
    public void testPrefetchToMany_OnJoinTableDisjoinedPrefetch() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).prefetch(Artist.ARTIST_EXHIBIT_ARRAY.disjoint()).orderBy(Artist.ARTIST_NAME.asc());
        List artists = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)artists.size());
            Artist a1 = (Artist)artists.get(0);
            Assert.assertEquals((Object)"artist2", (Object)a1.getArtistName());
            List toMany = (List)a1.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
            Assert.assertNotNull((Object)toMany);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
            Assert.assertEquals((long)2L, (long)toMany.size());
            ArtistExhibit artistExhibit = (ArtistExhibit)toMany.get(0);
            Assert.assertEquals((long)3L, (long)artistExhibit.getPersistenceState());
            Assert.assertSame((Object)a1, (Object)artistExhibit.getToArtist());
            Artist a2 = (Artist)artists.get(1);
            Assert.assertEquals((Object)"artist3", (Object)a2.getArtistName());
            List toMany2 = (List)a2.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
            Assert.assertNotNull((Object)toMany2);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
            Assert.assertEquals((long)3L, (long)toMany2.size());
            ArtistExhibit artistExhibit2 = (ArtistExhibit)toMany2.get(0);
            Assert.assertEquals((long)3L, (long)artistExhibit2.getPersistenceState());
            Assert.assertSame((Object)a2, (Object)artistExhibit2.getToArtist());
        });
    }

    @Test
    public void testPrefetchToMany_OnJoinTableJoinedPrefetch() throws Exception {
        this.createTwoArtistsWithExhibitsDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).prefetch(Artist.ARTIST_EXHIBIT_ARRAY.joint()).orderBy(Artist.ARTIST_NAME.asc());
        List artists = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)artists.size());
            Artist a1 = (Artist)artists.get(0);
            Assert.assertEquals((Object)"artist2", (Object)a1.getArtistName());
            List toMany = (List)a1.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
            Assert.assertNotNull((Object)toMany);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
            Assert.assertEquals((long)2L, (long)toMany.size());
            ArtistExhibit artistExhibit = (ArtistExhibit)toMany.get(0);
            Assert.assertEquals((long)3L, (long)artistExhibit.getPersistenceState());
            Assert.assertSame((Object)a1, (Object)artistExhibit.getToArtist());
            Artist a2 = (Artist)artists.get(1);
            Assert.assertEquals((Object)"artist3", (Object)a2.getArtistName());
            List toMany2 = (List)a2.readPropertyDirectly(Artist.ARTIST_EXHIBIT_ARRAY.getName());
            Assert.assertNotNull((Object)toMany2);
            Assert.assertFalse((boolean)((ValueHolder)((Object)toMany2)).isFault());
            Assert.assertEquals((long)3L, (long)toMany2.size());
            ArtistExhibit artistExhibit2 = (ArtistExhibit)toMany2.get(0);
            Assert.assertEquals((long)3L, (long)artistExhibit2.getPersistenceState());
            Assert.assertSame((Object)a2, (Object)artistExhibit2.getToArtist());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefetch_ToManyNoReverse() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjEntity paintingEntity = this.context.getEntityResolver().getObjEntity(Painting.class);
        ObjRelationship relationship = paintingEntity.getRelationship("toArtist");
        paintingEntity.removeRelationship("toArtist");
        try {
            List result = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
            this.queryInterceptor.runWithQueriesBlocked(() -> {
                Assert.assertFalse((boolean)result.isEmpty());
                Artist a1 = (Artist)result.get(0);
                List toMany = (List)a1.readPropertyDirectly("paintingArray");
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
            });
        }
        finally {
            paintingEntity.addRelationship(relationship);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefetch_ToManyNoReverseWithQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjEntity paintingEntity = this.context.getEntityResolver().getObjEntity(Painting.class);
        ObjRelationship relationship = paintingEntity.getRelationship("toArtist");
        paintingEntity.removeRelationship("toArtist");
        try {
            List result = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist2")).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
            this.queryInterceptor.runWithQueriesBlocked(() -> {
                Assert.assertFalse((boolean)result.isEmpty());
                Artist a1 = (Artist)result.get(0);
                List toMany = (List)a1.readPropertyDirectly("paintingArray");
                Assert.assertNotNull((Object)toMany);
                Assert.assertFalse((boolean)((ValueHolder)((Object)toMany)).isFault());
            });
        }
        finally {
            paintingEntity.addRelationship(relationship);
        }
    }

    @Test
    public void testPrefetch_ToOne() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint());
        List result = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertFalse((boolean)result.isEmpty());
            Painting p1 = (Painting)result.get(0);
            Object toOnePrefetch = p1.readNestedProperty("toArtist");
            Assert.assertNotNull((Object)toOnePrefetch);
            Assert.assertTrue((String)("Expected Artist, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof Artist));
            Artist a1 = (Artist)toOnePrefetch;
            Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
        });
    }

    @Test
    public void testPrefetch_ToOne_DbPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).and(Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).eq("artist2"));
        List results = q.select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testPrefetch_ToOne_ObjPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).and(Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).eq("artist2"));
        List results = q.select(this.context);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testPrefetch_ReflexiveRelationship() {
        ArtGroup parent = (ArtGroup)this.context.newObject("ArtGroup");
        parent.setName("parent");
        ArtGroup child = (ArtGroup)this.context.newObject("ArtGroup");
        child.setName("child");
        child.setToParentGroup(parent);
        this.context.commitChanges();
        ObjectSelect<ArtGroup> q = ObjectSelect.query(ArtGroup.class).where(ArtGroup.NAME.eq("child")).prefetch("toParentGroup", 0);
        List results = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            ArtGroup fetchedChild = (ArtGroup)results.get(0);
            Assert.assertEquals((long)3L, (long)fetchedChild.getToParentGroup().getPersistenceState());
        });
        child.setToParentGroup(null);
        this.context.commitChanges();
    }

    @Test
    public void testPrefetch_ToOneWithQualifierOverlappingPrefetchPath() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).eq("artist3")).prefetch(Painting.TO_ARTIST.disjoint());
        List results = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Painting painting = (Painting)results.get(0);
            Assert.assertEquals((long)3L, (long)painting.getToArtist().getPersistenceState());
        });
    }

    @Test
    public void testPrefetch_ToOneWith_OuterJoinFlattenedQualifier() throws Exception {
        this.tArtGroup.insert(new Object[]{1, "AG"});
        this.tArtist.insert(new Object[]{11, "artist2"});
        this.tArtist.insert(new Object[]{101, "artist3"});
        this.tPainting.insert(new Object[]{6, "p_artist3", 101, 1000, null});
        this.tPainting.insert(new Object[]{7, "p_artist21", 11, 2000, null});
        this.tPainting.insert(new Object[]{8, "p_artist22", 11, 3000, null});
        this.tArtistGroup.insert(new Object[]{101, 1});
        Expression exp = PropertyFactory.createBase("groupArray+.name", String.class).eq("XX").orExp(Artist.ARTIST_NAME.eq("artist2"));
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(exp).prefetch(Artist.PAINTING_ARRAY.disjoint());
        List results = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Artist a = (Artist)results.get(0);
            Assert.assertEquals((Object)"artist2", (Object)a.getArtistName());
            Assert.assertEquals((long)2L, (long)a.getPaintingArray().size());
        });
    }

    @Test
    public void testPrefetch9() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        Artist artist1 = (Artist)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist3")).select(this.context).get(0);
        Expression exp = ExpressionFactory.noMatchExp("toArtist", (Object)artist1);
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.eq(artist1)).prefetch("toArtist", 0);
        List results = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Painting px = (Painting)results.get(0);
            Artist ax = (Artist)px.readProperty(Painting.TO_ARTIST.getName());
            Assert.assertEquals((long)3L, (long)ax.getPersistenceState());
        });
    }

    @Test
    public void testPrefetch_OneToOneWithQualifier() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).like("a%")).prefetch(Painting.TO_PAINTING_INFO.disjoint()).orderBy(Painting.PAINTING_TITLE.asc());
        List results = q.select(this.context);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)results.size());
            Painting p0 = (Painting)results.get(0);
            Object o2 = p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
            Assert.assertTrue((boolean)(o2 instanceof PaintingInfo));
            PaintingInfo pi2 = (PaintingInfo)o2;
            Assert.assertEquals((long)3L, (long)pi2.getPersistenceState());
            Assert.assertEquals((long)Cayenne.intPKForObject(p0), (long)Cayenne.intPKForObject(pi2));
            Painting p1 = (Painting)results.get(1);
            Assert.assertNull((Object)p1.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName()));
            Assert.assertEquals((long)3L, (long)p1.getPersistenceState());
        });
    }

    @Test
    public void testPrefetchToMany_DateInQualifier() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class).where(Artist.DATE_OF_BIRTH.eq(new Date())).prefetch("paintingArray", 0);
        this.context.performQuery(q);
    }

    @Test
    public void testPrefetchingToOneNull() throws Exception {
        this.tPainting.insert(new Object[]{6, "p_Xty", null, 1000, null});
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint());
        List<Painting> paintings = this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)paintings.size());
            Painting p2 = (Painting)paintings.get(0);
            Assert.assertNull((Object)p2.readProperty(Painting.TO_ARTIST.getName()));
        });
    }

    @Test
    public void testPrefetchToOneSharedCache() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            List cachedResult = this.context.select(q);
            Assert.assertFalse((boolean)cachedResult.isEmpty());
            Painting p1 = (Painting)cachedResult.get(0);
            Object toOnePrefetch = p1.readNestedProperty("toArtist");
            Assert.assertNotNull((Object)toOnePrefetch);
            Assert.assertTrue((String)("Expected Artist, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof Artist));
            Artist a1 = (Artist)toOnePrefetch;
            Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
            this.context.performQuery(q);
        });
    }

    @Test
    public void testPrefetchToOneLocalCache() throws Exception {
        this.createTwoArtistsAndTwoPaintingsDataSet();
        ObjectSelect<Painting> q = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        this.context.select(q);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            List cachedResult = this.context.select(q);
            Assert.assertFalse((boolean)cachedResult.isEmpty());
            Painting p1 = (Painting)cachedResult.get(0);
            Object toOnePrefetch = p1.readNestedProperty("toArtist");
            Assert.assertNotNull((Object)toOnePrefetch);
            Assert.assertTrue((String)("Expected Artist, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof Artist));
            Artist a1 = (Artist)toOnePrefetch;
            Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
            this.context.performQuery(q);
        });
    }

    @Test
    public void testPrefetchToOneWithBackRelationship() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).and(Painting.PAINTING_TITLE.eq("p_artist2")).prefetch(Painting.TO_PAINTING_INFO.disjoint()).prefetch(Painting.TO_PAINTING_INFO.dot(PaintingInfo.PAINTING).disjoint());
        List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Painting p0 = (Painting)results.get(0);
            PaintingInfo pi0 = (PaintingInfo)p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
            Assert.assertNotNull((Object)pi0);
            Assert.assertNotNull((Object)pi0.readPropertyDirectly(PaintingInfo.PAINTING.getName()));
        });
    }

    @Test
    public void testPrefetchPaintingOverToOneAndToMany() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).and(Painting.PAINTING_TITLE.eq("p_artist2")).prefetch(Painting.TO_ARTIST.disjoint()).prefetch(Painting.TO_ARTIST.dot(Artist.PAINTING_ARRAY).disjoint());
        List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Painting p0 = (Painting)results.get(0);
            Artist a0 = (Artist)p0.readPropertyDirectly(Painting.TO_ARTIST.getName());
            Assert.assertNotNull((Object)a0);
            List paintings = (List)a0.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertEquals((long)2L, (long)paintings.size());
        });
    }

    @Test
    public void testPrefetchToOneWithBackRelationship_Joint() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).and(Painting.PAINTING_TITLE.eq("p_artist2")).prefetch(Painting.TO_PAINTING_INFO.joint()).prefetch(Painting.TO_PAINTING_INFO.dot(PaintingInfo.PAINTING).joint());
        List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Painting p0 = (Painting)results.get(0);
            PaintingInfo pi0 = (PaintingInfo)p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
            Assert.assertNotNull((Object)pi0);
            Assert.assertNotNull((Object)pi0.readPropertyDirectly(PaintingInfo.PAINTING.getName()));
        });
    }

    @Test
    public void testPrefetchJointAndDisjointByIdTogether() throws Exception {
        this.createArtistWithTwoPaintingsAndTwoInfosDataSet();
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).and(Painting.PAINTING_TITLE.eq("p_artist2")).prefetch(Painting.TO_ARTIST.joint()).prefetch(Painting.TO_PAINTING_INFO.disjointById());
        List<Painting> results = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)results.size());
            Painting p0 = (Painting)results.get(0);
            Artist a0 = (Artist)p0.readPropertyDirectly(Painting.TO_ARTIST.getName());
            Assert.assertNotNull((Object)a0);
            PaintingInfo info = (PaintingInfo)p0.readPropertyDirectly(Painting.TO_PAINTING_INFO.getName());
            Assert.assertNotNull((Object)info);
        });
    }

    @Test
    public void testPrefetchWithLocalCache() throws Exception {
        this.createArtistWithPaintingAndGallery();
        List paintings = ObjectSelect.query(Painting.class).localCache("g1").select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Fault));
        paintings = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint()).localCache("g1").select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Artist));
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            List paintings1 = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.joint()).localCache("g1").select(this.context);
            Assert.assertEquals((long)1L, (long)paintings1.size());
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Artist));
        });
    }

    @Test
    public void testPrefetchWithSharedCache() throws Exception {
        this.createArtistWithPaintingAndGallery();
        ObjectSelect<Painting> s1 = ObjectSelect.query(Painting.class).sharedCache("g1");
        ObjectSelect<Painting> s2 = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).sharedCache("g1");
        ObjectSelect<Painting> s3 = ObjectSelect.query(Painting.class).prefetch(Painting.TO_GALLERY.joint()).sharedCache("g1");
        ObjectSelect<Painting> s4 = ObjectSelect.query(Painting.class).prefetch(Painting.TO_ARTIST.disjoint()).prefetch(Painting.TO_GALLERY.joint()).sharedCache("g1");
        List paintings = s1.select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Fault));
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Fault));
        paintings = s2.select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Artist));
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Fault));
        paintings = s3.select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Fault));
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Gallery));
        paintings = s4.select(this.context);
        Assert.assertEquals((long)1L, (long)paintings.size());
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Artist));
        Assert.assertTrue((boolean)(((Painting)paintings.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Gallery));
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            List paintings1 = s2.select(this.context);
            Assert.assertEquals((long)1L, (long)paintings1.size());
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Artist));
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Fault));
            paintings1 = s3.select(this.context);
            Assert.assertEquals((long)1L, (long)paintings1.size());
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Fault));
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Gallery));
            paintings1 = s4.select(this.context);
            Assert.assertEquals((long)1L, (long)paintings1.size());
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_ARTIST.getName()) instanceof Artist));
            Assert.assertTrue((boolean)(((Painting)paintings1.get(0)).readPropertyDirectly(Painting.TO_GALLERY.getName()) instanceof Gallery));
        });
    }
}

