/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.types.ByteArrayTypeTest;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.testdo.lob.BlobTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lob.xml")
public class DataContextBlobIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DataContext context2;
    @Inject
    private DataContext context3;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    protected boolean skipTests() {
        return !this.accessStackAdapter.supportsLobs();
    }

    protected boolean skipEmptyLOBTests() {
        return !this.accessStackAdapter.handlesNullVsEmptyLOBs();
    }

    @Test
    public void testManyBlobsInOneTX() throws Exception {
        if (this.skipTests()) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            BlobTestEntity b = this.context.newObject(BlobTestEntity.class);
            byte[] bytes = new byte[1024];
            for (int j = 0; j < 1024; ++j) {
                bytes[j] = (byte)(65 + (50 + j) % 50);
            }
            b.setBlobCol(bytes);
            this.context.commitChanges();
        }
        List objects2 = ObjectSelect.query(BlobTestEntity.class).select(this.context2);
        Assert.assertEquals((long)3L, (long)objects2.size());
    }

    @Test
    public void testEmptyBlob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        if (this.skipEmptyLOBTests()) {
            return;
        }
        this.runWithBlobSize(0);
    }

    @Test
    public void test5ByteBlob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.runWithBlobSize(5);
    }

    @Test
    public void test5KByteBlob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.runWithBlobSize(5120);
    }

    @Test
    public void test1MBBlob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        this.runWithBlobSize(0x100000);
    }

    @Test
    public void testNullBlob() throws Exception {
        if (this.skipTests()) {
            return;
        }
        byte[] bytes2 = new byte[]{97, 98, 99, 100};
        this.context.newObject(BlobTestEntity.class);
        this.context.commitChanges();
        List objects2 = ObjectSelect.query(BlobTestEntity.class).select(this.context2);
        Assert.assertEquals((long)1L, (long)objects2.size());
        BlobTestEntity blobObj2 = (BlobTestEntity)objects2.get(0);
        Assert.assertNull((Object)blobObj2.getBlobCol());
        blobObj2.setBlobCol(bytes2);
        this.context2.commitChanges();
        List objects3 = ObjectSelect.query(BlobTestEntity.class).select(this.context3);
        Assert.assertEquals((long)1L, (long)objects3.size());
        BlobTestEntity blobObj3 = (BlobTestEntity)objects3.get(0);
        ByteArrayTypeTest.assertByteArraysEqual(blobObj2.getBlobCol(), blobObj3.getBlobCol());
    }

    protected void runWithBlobSize(int sizeBytes) throws Exception {
        BlobTestEntity blobObj1 = this.context.newObject(BlobTestEntity.class);
        byte[] bytes = new byte[sizeBytes];
        for (int i = 0; i < sizeBytes; ++i) {
            bytes[i] = (byte)(65 + (50 + i) % 50);
        }
        blobObj1.setBlobCol(bytes);
        this.context.commitChanges();
        List objects2 = ObjectSelect.query(BlobTestEntity.class).select(this.context2);
        Assert.assertEquals((long)1L, (long)objects2.size());
        BlobTestEntity blobObj2 = (BlobTestEntity)objects2.get(0);
        ByteArrayTypeTest.assertByteArraysEqual(blobObj1.getBlobCol(), blobObj2.getBlobCol());
        blobObj2.setBlobCol(new byte[]{49, 50});
        this.context2.commitChanges();
        List objects3 = ObjectSelect.query(BlobTestEntity.class).select(this.context3);
        Assert.assertEquals((long)1L, (long)objects3.size());
        BlobTestEntity blobObj3 = (BlobTestEntity)objects3.get(0);
        ByteArrayTypeTest.assertByteArraysEqual(blobObj2.getBlobCol(), blobObj3.getBlobCol());
    }
}

