/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.cay_2641.ArtistLazy;
import org.apache.cayenne.testdo.cay_2641.DatamapLazy;
import org.apache.cayenne.testdo.cay_2641.PaintingLazy;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cay2641/cayenne-cay-2641.xml")
public class Cay2641
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private DbAdapter adapter;

    @Before
    public void setup() throws Exception {
        TableHelper th = new TableHelper(this.dbHelper, "ArtistLazy").setColumns(new String[]{"ID", "NAME", "SURNAME"}).setColumnTypes(new int[]{4, 12, 12});
        th.insert(new Object[]{1, "artist1", "artist2"});
        th = new TableHelper(this.dbHelper, "PaintingLazy").setColumns(new String[]{"ID", "NAME", "ARTIST_ID"}).setColumnTypes(new int[]{4, 12, 4});
        th.insert(new Object[]{1, "painting1", 1});
    }

    @Test
    public void testTranslatorSql() {
        ObjectSelect<ArtistLazy> artists = ObjectSelect.query(ArtistLazy.class);
        DefaultSelectTranslator translator = new DefaultSelectTranslator(artists, this.adapter, this.context.getEntityResolver());
        String sql = translator.getSql();
        Assert.assertFalse((boolean)sql.contains("t0.NAME"));
        String string = "SELECT t0.SURNAME, t0.ID FROM ArtistLazy t0";
        Assert.assertTrue((boolean)sql.equals(string));
        ColumnSelect select = ObjectSelect.columnQuery(ArtistLazy.class, ArtistLazy.NAME);
        translator = new DefaultSelectTranslator(select, this.adapter, this.context.getEntityResolver());
        sql = translator.getSql();
        Assert.assertTrue((boolean)sql.contains("t0.NAME"));
    }

    @Test
    public void testTypeAttributes() {
        List artists = ObjectSelect.query(ArtistLazy.class).select(this.context);
        Object object = ((ArtistLazy)artists.get(0)).readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
        object = ((ArtistLazy)artists.get(0)).readPropertyDirectly("surname");
        Assert.assertTrue((boolean)object.equals("artist2"));
    }

    @Test
    public void testTypeLazyAttribute() {
        ArtistLazy artist = ObjectSelect.query(ArtistLazy.class).selectFirst(this.context);
        Object object = artist.readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
        artist.getName();
        object = artist.readPropertyDirectly("name");
        Assert.assertTrue((boolean)object.equals("artist1"));
    }

    @Test
    public void testPrefetchLazyTranslatorSql() {
        ObjectSelect<PaintingLazy> paintingLazyObjectSelect = ObjectSelect.query(PaintingLazy.class).prefetch(PaintingLazy.ARTIST.joint());
        DefaultSelectTranslator translator = new DefaultSelectTranslator(paintingLazyObjectSelect, this.adapter, this.context.getEntityResolver());
        String sql = translator.getSql();
        Assert.assertFalse((boolean)sql.contains("t0.NAME"));
        String string = "SELECT DISTINCT t0.ARTIST_ID, t0.ID, t1.ID, t1.SURNAME FROM PaintingLazy t0 LEFT JOIN ArtistLazy t1 ON t0.ARTIST_ID = t1.ID";
        Assert.assertTrue((boolean)sql.equals(string));
    }

    @Test
    public void testPrefetchLazyTypeAttributes() {
        List paintingLazyList = ObjectSelect.query(PaintingLazy.class).prefetch(PaintingLazy.ARTIST.joint()).select(this.context);
        Object object = ((PaintingLazy)paintingLazyList.get(0)).readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
        object = ((PaintingLazy)paintingLazyList.get(0)).getName();
        Assert.assertTrue((boolean)(object instanceof String));
        Assert.assertTrue((boolean)object.equals("painting1"));
        ArtistLazy artist = (ArtistLazy)((PaintingLazy)paintingLazyList.get(0)).readPropertyDirectly("artist");
        object = artist.readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
        object = artist.readPropertyDirectly("surname");
        Assert.assertTrue((boolean)object.equals("artist2"));
        object = artist.getName();
        Assert.assertTrue((boolean)(object instanceof String));
        Assert.assertTrue((boolean)object.equals("artist1"));
    }

    @Test
    public void testsSimpleSelectCustomer() {
        DatamapLazy optimistic = DatamapLazy.getInstance();
        List<ArtistLazy> artistLazies = optimistic.performSimpleSelect(this.context);
        Object object = artistLazies.get(0).readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
        object = artistLazies.get(0).readPropertyDirectly("surname");
        Assert.assertTrue((boolean)(object instanceof String));
        Assert.assertTrue((boolean)object.equals("artist2"));
    }

    @Test
    public void testsPrefetchSelectCustomer() {
        DatamapLazy optimistic = DatamapLazy.getInstance();
        List<PaintingLazy> paintingLazies = optimistic.performPrefetchSelect(this.context);
        Object object = paintingLazies.get(0).readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
        ArtistLazy artist = (ArtistLazy)paintingLazies.get(0).readPropertyDirectly("artist");
        object = artist.readPropertyDirectly("name");
        Assert.assertTrue((boolean)(object instanceof Fault));
    }
}

