/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CAY2509IT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPainting;

    @Before
    public void before() {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST").setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"}).setColumnTypes(new int[]{-5, 1, 91});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING").setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE"}).setColumnTypes(new int[]{4, -5, 12});
    }

    @Test
    public void testSelectionProblem() throws SQLException {
        this.tArtist.insert(new Object[]{1, "A1", null});
        this.tPainting.insert(new Object[]{1, 1, "P1"});
        ObjectContext context1 = this.runtime.newContext();
        List artists1 = ObjectSelect.query(Artist.class).select(context1);
        Assert.assertEquals((Object)"P1", (Object)((Artist)artists1.get(0)).getPaintingArray().get(0).getPaintingTitle());
        this.tPainting.update().set("PAINTING_TITLE", (Object)"P2").where("PAINTING_ID", (Object)1).execute();
        ObjectContext context2 = this.runtime.newContext();
        List artists2 = ObjectSelect.query(Artist.class).select(context2);
        Assert.assertEquals((Object)"P2", (Object)((Artist)artists2.get(0)).getPaintingArray().get(0).getPaintingTitle());
    }

    @Test
    public void testChangesInTwoContexts() throws SQLException {
        this.tArtist.insert(new Object[]{1, "A1", null});
        ObjectContext context1 = this.runtime.newContext();
        Artist artist = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("A1")).selectFirst(context1);
        Assert.assertEquals((Object)"A1", (Object)artist.getArtistName());
        artist.setArtistName("A2");
        Assert.assertEquals((Object)"A2", (Object)artist.getArtistName());
        ObjectContext context2 = this.runtime.newContext();
        List artists = ObjectSelect.query(Artist.class).select(context2);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"A1", (Object)((Artist)artists.get(0)).getArtistName());
    }

    @Test
    public void testChangesInChildContext() throws SQLException {
        this.tArtist.insert(new Object[]{1, "A1", null});
        ObjectContext parentContext1 = this.runtime.newContext();
        ObjectContext context1 = this.runtime.newContext(parentContext1);
        Artist artist = ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("A1")).selectFirst(context1);
        Assert.assertEquals((Object)"A1", (Object)artist.getArtistName());
        artist.setArtistName("A2");
        context1.commitChangesToParent();
        ObjectContext parentContext2 = this.runtime.newContext();
        List artists = ObjectSelect.query(Artist.class).select(parentContext2);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((Object)"A1", (Object)((Artist)artists.get(0)).getArtistName());
    }
}

