/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.MockPersistentObject;
import org.apache.cayenne.ObjectContextStateLog;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.GraphManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ContextStateRecorderTest {
    private ObjectContextStateLog recorder;
    private GraphManager mockGraphManager;

    @Before
    public void before() {
        this.mockGraphManager = (GraphManager)Mockito.mock(GraphManager.class);
        this.recorder = new ObjectContextStateLog(this.mockGraphManager);
    }

    @Test
    public void testDirtyNodesInState() {
        Assert.assertNotNull(this.recorder.dirtyNodes(4));
        Assert.assertNotNull(this.recorder.dirtyNodes(3));
        Assert.assertNotNull(this.recorder.dirtyNodes(6));
        Assert.assertNotNull(this.recorder.dirtyNodes(2));
        Assert.assertNotNull(this.recorder.dirtyNodes(1));
        Assert.assertNotNull(this.recorder.dirtyNodes(5));
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(4).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(3).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(6).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(2).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(1).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(5).isEmpty());
        MockPersistentObject modified = new MockPersistentObject();
        modified.setObjectId(ObjectId.of("MockPersistentObject", "key", "value1"));
        modified.setPersistenceState(4);
        Mockito.when((Object)this.mockGraphManager.getNode(modified.getObjectId())).thenReturn((Object)modified);
        this.recorder.nodePropertyChanged(modified.getObjectId(), "a", "b", "c");
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(4).contains(modified));
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(3).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(6).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(2).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(1).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(5).isEmpty());
        MockPersistentObject deleted = new MockPersistentObject();
        deleted.setObjectId(ObjectId.of("MockPersistentObject", "key", "value2"));
        deleted.setPersistenceState(6);
        Mockito.when((Object)this.mockGraphManager.getNode(deleted.getObjectId())).thenReturn((Object)deleted);
        this.recorder.nodeRemoved(deleted.getObjectId());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(4).contains(modified));
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(3).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(6).contains(deleted));
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(2).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(1).isEmpty());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes(5).isEmpty());
    }

    @Test
    public void testDirtyNodes() {
        Assert.assertNotNull(this.recorder.dirtyNodes());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes().isEmpty());
        MockPersistentObject object = new MockPersistentObject();
        object.setObjectId(ObjectId.of("MockPersistentObject", "key", "value"));
        object.setPersistenceState(4);
        Mockito.when((Object)this.mockGraphManager.getNode(object.getObjectId())).thenReturn((Object)object);
        this.recorder.nodePropertyChanged(object.getObjectId(), "a", "b", "c");
        Assert.assertTrue((boolean)this.recorder.dirtyNodes().contains(object));
        this.recorder.clear();
        Assert.assertNotNull(this.recorder.dirtyNodes());
        Assert.assertTrue((boolean)this.recorder.dirtyNodes().isEmpty());
    }

    @Test
    public void testHasChanges() {
        Assert.assertFalse((boolean)this.recorder.hasChanges());
        MockPersistentObject object = new MockPersistentObject();
        object.setObjectId(ObjectId.of("MockPersistentObject", "key", "value"));
        object.setPersistenceState(4);
        this.recorder.nodePropertyChanged(object.getObjectId(), "xyz", "a", "b");
        Assert.assertTrue((boolean)this.recorder.hasChanges());
        this.recorder.clear();
        Assert.assertFalse((boolean)this.recorder.hasChanges());
    }
}

