/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.exp.parser.ParseException;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.Util;

public class ASTEnum
extends ASTScalar {
    ASTEnum(int id) {
        super(id);
    }

    public ASTEnum() {
        super(58);
    }

    public ASTEnum(Object value) {
        super(58);
        this.setValue(value);
    }

    @Override
    protected Object evaluateNode(Object o) {
        return this.getValueAsEnum().resolve();
    }

    @Override
    public Expression shallowCopy() {
        ASTEnum copy = new ASTEnum(this.id);
        copy.value = this.value;
        return copy;
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        Enum<?> scalar = this.getValueAsEnum().resolve();
        SimpleNode.encodeScalarAsEJBQL(parameterAccumulator, out, scalar);
    }

    @Override
    public Object getValue() {
        return this.getValueAsEnum().resolve();
    }

    public void setEnumValue(String enumPath) throws ParseException {
        if (enumPath == null) {
            throw new ParseException("Null 'enumPath'");
        }
        int dot = enumPath.lastIndexOf(46);
        if (dot <= 0 || dot == enumPath.length() - 1) {
            throw new ParseException("Invalid enum path: " + enumPath);
        }
        String className = enumPath.substring(0, dot);
        String enumName = enumPath.substring(dot + 1);
        this.setValue(new EnumValue(className, enumName));
    }

    EnumValue getValueAsEnum() {
        return (EnumValue)this.value;
    }

    static final class EnumValue {
        String className;
        String enumName;

        EnumValue(String className, String enumName) {
            this.className = Objects.requireNonNull(className);
            this.enumName = Objects.requireNonNull(enumName);
        }

        Enum<?> resolve() {
            Class<?> enumClass;
            try {
                enumClass = Util.getJavaClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new CayenneRuntimeException("Enum class not found: " + this.className, new Object[0]);
            }
            if (!enumClass.isEnum()) {
                throw new CayenneRuntimeException("Specified class is not an enum: " + this.className, new Object[0]);
            }
            try {
                return Enum.valueOf(enumClass, this.enumName);
            }
            catch (IllegalArgumentException e) {
                throw new CayenneRuntimeException("Invalid enum path: " + this.className + "." + this.enumName, new Object[0]);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || EnumValue.class != o.getClass()) {
                return false;
            }
            EnumValue enumValue = (EnumValue)o;
            return this.className.equals(enumValue.className) && this.enumName.equals(enumValue.enumName);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.enumName.hashCode();
            return result;
        }

        public String toString() {
            return "enum:" + this.className + "." + this.enumName;
        }
    }
}

