/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.util.SingleEntryMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SingleEntryMapTest {
    private SingleEntryMap<String, Integer> map;

    @Before
    public void createMap() {
        this.map = new SingleEntryMap("test");
    }

    @Test
    public void constructor() {
        Assert.assertEquals((long)0L, (long)this.map.size());
        Assert.assertTrue((boolean)this.map.isEmpty());
        Assert.assertNull((Object)this.map.get("test"));
        Assert.assertTrue((boolean)this.map.keySet().isEmpty());
        Assert.assertTrue((boolean)this.map.values().isEmpty());
        Assert.assertEquals((Object)"test", (Object)this.map.getKey());
        Assert.assertNull((Object)this.map.getValue());
    }

    @Test(expected=NullPointerException.class)
    public void constructorWithNullKey() {
        new SingleEntryMap(null);
    }

    @Test
    public void constructorWithValue() {
        SingleEntryMap<String, Integer> mapWithValue = new SingleEntryMap<String, Integer>("test", 123);
        Assert.assertEquals((long)1L, (long)mapWithValue.size());
        Assert.assertEquals((long)123L, (long)((Integer)mapWithValue.get("test")).intValue());
        mapWithValue.put("test", null);
        Assert.assertNull(mapWithValue.get("test"));
        mapWithValue.put("test", 321);
        Assert.assertEquals((long)321L, (long)((Integer)mapWithValue.get("test")).intValue());
    }

    @Test
    public void constructorWithNullValue() {
        SingleEntryMap<String, Object> mapWithValue = new SingleEntryMap<String, Object>("test", null);
        Assert.assertEquals((long)0L, (long)mapWithValue.size());
        Assert.assertNull(mapWithValue.get("test"));
        mapWithValue.put("test", 321);
        Assert.assertEquals((long)321L, (long)((Integer)mapWithValue.get("test")).intValue());
    }

    @Test(expected=NullPointerException.class)
    public void constructorWithNullKeyAndValue() {
        new SingleEntryMap<Object, Integer>(null, 123);
    }

    @Test
    public void entrySet() {
        Assert.assertTrue((boolean)this.map.entrySet().isEmpty());
        this.map.setValue(123);
        Assert.assertEquals((long)1L, (long)this.map.entrySet().size());
        Assert.assertEquals((Object)"test", (Object)this.map.entrySet().iterator().next().getKey());
        Assert.assertEquals((long)123L, (long)this.map.entrySet().iterator().next().getValue().intValue());
        Assert.assertEquals((long)1L, (long)this.map.entrySet().size());
    }

    @Test
    public void containsKey() {
        Assert.assertFalse((boolean)this.map.containsKey("test"));
        Assert.assertFalse((boolean)this.map.containsKey("test1"));
        this.map.put("test", 123);
        Assert.assertTrue((boolean)this.map.containsKey("test"));
        Assert.assertFalse((boolean)this.map.containsKey("test1"));
        this.map.put("test", null);
        Assert.assertFalse((boolean)this.map.containsKey("test"));
        Assert.assertFalse((boolean)this.map.containsKey("test1"));
    }

    @Test
    public void size() {
        Assert.assertEquals((long)0L, (long)this.map.size());
        this.map.put("test", 123);
        Assert.assertEquals((long)1L, (long)this.map.size());
        this.map.put("test", null);
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void isEmpty() {
        Assert.assertTrue((boolean)this.map.isEmpty());
        this.map.put("test", 123);
        Assert.assertFalse((boolean)this.map.isEmpty());
        this.map.put("test", null);
        Assert.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    public void containsValue() {
        Assert.assertFalse((boolean)this.map.containsValue(123));
        this.map.put("test", 123);
        Assert.assertTrue((boolean)this.map.containsValue(123));
        this.map.put("test", null);
        Assert.assertFalse((boolean)this.map.containsValue(123));
    }

    @Test
    public void get() {
        Assert.assertNull((Object)this.map.get("test"));
        Assert.assertNull((Object)this.map.get("test2"));
        this.map.put("test", 123);
        Assert.assertEquals((long)123L, (long)this.map.get("test").intValue());
        Assert.assertNull((Object)this.map.get("test2"));
        this.map.put("test", null);
        Assert.assertNull((Object)this.map.get("test"));
        Assert.assertNull((Object)this.map.get("test2"));
    }

    @Test
    public void put() {
        Assert.assertNull((Object)this.map.put("test", 123));
        Assert.assertEquals((long)123L, (long)this.map.put("test", 321).intValue());
        Assert.assertEquals((long)321L, (long)((Integer)this.map.put("test", null)).intValue());
        Assert.assertNull((Object)this.map.put("test", 123));
    }

    @Test(expected=IllegalArgumentException.class)
    public void putWrongKey() {
        this.map.put("test2", 321);
    }

    @Test
    public void remove() {
        Assert.assertNull((Object)this.map.remove("test"));
        Assert.assertNull((Object)this.map.remove("test2"));
        this.map.put("test", 123);
        Assert.assertEquals((long)123L, (long)this.map.remove("test").intValue());
        Assert.assertNull((Object)this.map.remove("test"));
    }

    @Test
    public void putAll() {
        Assert.assertNull((Object)this.map.get("test"));
        Assert.assertNull((Object)this.map.get("test2"));
        Map<String, Integer> map2 = Collections.singletonMap("test", 123);
        this.map.putAll(map2);
        Assert.assertEquals((long)123L, (long)this.map.get("test").intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void putAllWrongKey() {
        Assert.assertNull((Object)this.map.get("test"));
        Assert.assertNull((Object)this.map.get("test2"));
        Map<String, Integer> map2 = Collections.singletonMap("test2", 123);
        this.map.putAll(map2);
    }

    @Test
    public void clear() {
        Assert.assertEquals((long)0L, (long)this.map.size());
        this.map.clear();
        Assert.assertEquals((long)0L, (long)this.map.size());
        this.map.put("test", 123);
        Assert.assertEquals((long)1L, (long)this.map.size());
        this.map.clear();
        Assert.assertEquals((long)0L, (long)this.map.size());
        Assert.assertNull((Object)this.map.get("test"));
    }

    @Test
    public void keySet() {
        Assert.assertTrue((boolean)this.map.keySet().isEmpty());
        this.map.put("test", 123);
        Assert.assertEquals((long)1L, (long)this.map.keySet().size());
        Assert.assertEquals((Object)"test", (Object)this.map.keySet().iterator().next());
        Assert.assertEquals((Object)"test", (Object)this.map.keySet().iterator().next());
        this.map.clear();
        Assert.assertTrue((boolean)this.map.keySet().isEmpty());
    }

    @Test
    public void values() {
        Assert.assertTrue((boolean)this.map.values().isEmpty());
        this.map.put("test", 123);
        Assert.assertEquals((long)1L, (long)this.map.keySet().size());
        Assert.assertEquals((long)123L, (long)this.map.values().iterator().next().intValue());
        Assert.assertEquals((long)123L, (long)this.map.values().iterator().next().intValue());
        this.map.clear();
        Assert.assertTrue((boolean)this.map.values().isEmpty());
    }

    @Test
    public void getKey() {
        Assert.assertEquals((Object)"test", (Object)this.map.getKey());
        this.map.put("test", 123);
        Assert.assertEquals((Object)"test", (Object)this.map.getKey());
    }

    @Test
    public void getValue() {
        Assert.assertNull((Object)this.map.getValue());
        this.map.put("test", 123);
        Assert.assertEquals((long)123L, (long)this.map.getValue().intValue());
        this.map.put("test", null);
        Assert.assertNull((Object)this.map.getValue());
        this.map.put("test", 321);
        Assert.assertEquals((long)321L, (long)this.map.getValue().intValue());
    }

    @Test
    public void setValue() {
        Assert.assertNull((Object)this.map.getValue());
        this.map.setValue(123);
        Assert.assertEquals((long)123L, (long)this.map.getValue().intValue());
        this.map.setValue(null);
        Assert.assertNull((Object)this.map.getValue());
        this.map.setValue(321);
        Assert.assertEquals((long)321L, (long)this.map.getValue().intValue());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals(this.map, Collections.emptyMap());
        Assert.assertNotEquals(this.map, Collections.singletonMap("test", null));
        this.map.put("test", 123);
        Assert.assertEquals(this.map, Collections.singletonMap("test", 123));
        Assert.assertNotEquals(this.map, Collections.singletonMap("test", null));
        Assert.assertNotEquals(this.map, Collections.singletonMap("test2", 123));
        Assert.assertNotEquals(this.map, Collections.singletonMap("test", 124));
        this.map.put("test", 321);
        HashMap<String, Integer> other = new HashMap<String, Integer>();
        other.put("test", 321);
        Assert.assertEquals(this.map, other);
        Assert.assertEquals(this.map, this.map);
        Assert.assertNotEquals(this.map, new ArrayList());
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)Collections.emptyMap().hashCode(), (long)this.map.hashCode());
        Assert.assertEquals((long)this.map.hashCode(), (long)this.map.hashCode());
        Assert.assertNotEquals((long)Collections.singletonMap("test", null).hashCode(), (long)this.map.hashCode());
        this.map.put("test", 123);
        Assert.assertEquals((long)Collections.singletonMap("test", 123).hashCode(), (long)this.map.hashCode());
        Assert.assertNotEquals((long)Collections.singletonMap("test", null).hashCode(), (long)this.map.hashCode());
        Assert.assertNotEquals((long)Collections.singletonMap("test2", 123).hashCode(), (long)this.map.hashCode());
        Assert.assertNotEquals((long)Collections.singletonMap("test", 124).hashCode(), (long)this.map.hashCode());
        Assert.assertEquals((long)this.map.hashCode(), (long)this.map.hashCode());
        this.map.put("test", 321);
        HashMap<String, Integer> other = new HashMap<String, Integer>();
        other.put("test", 321);
        Assert.assertEquals((long)other.hashCode(), (long)this.map.hashCode());
        Assert.assertEquals((long)this.map.hashCode(), (long)this.map.hashCode());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)Collections.emptyMap().toString(), (Object)this.map.toString());
        Assert.assertNotEquals((Object)Collections.singletonMap("test", null).toString(), (Object)this.map.toString());
        this.map.put("test", 123);
        Assert.assertEquals((Object)Collections.singletonMap("test", 123).toString(), (Object)this.map.toString());
        Assert.assertNotEquals((Object)Collections.singletonMap("test", null).toString(), (Object)this.map.toString());
        Assert.assertNotEquals((Object)Collections.singletonMap("test2", 123).toString(), (Object)this.map.toString());
        Assert.assertNotEquals((Object)Collections.singletonMap("test", 124).toString(), (Object)this.map.toString());
        this.map.put("test", 321);
        HashMap<String, Integer> other = new HashMap<String, Integer>();
        other.put("test", 321);
        Assert.assertEquals((Object)((Object)other).toString(), (Object)this.map.toString());
    }

    @Test
    public void forEach() {
        this.map.forEach((k, v) -> Assert.fail((String)("Unexpected value in map: " + k + "=" + v)));
        this.map.put("test", 123);
        AtomicInteger counter = new AtomicInteger();
        this.map.forEach((k, v) -> {
            Assert.assertEquals((Object)"test", (Object)k);
            Assert.assertEquals((long)123L, (long)v.intValue());
            counter.incrementAndGet();
        });
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void getOrDefault() {
        Assert.assertEquals((long)321L, (long)this.map.getOrDefault("test", 321).intValue());
        Assert.assertEquals((long)321L, (long)this.map.getOrDefault("test2", 321).intValue());
        this.map.put("test", 123);
        Assert.assertEquals((long)123L, (long)this.map.getOrDefault("test", 321).intValue());
        Assert.assertEquals((long)321L, (long)this.map.getOrDefault("test2", 321).intValue());
    }

    @Test
    public void putIfAbsent() {
        Assert.assertNull((Object)this.map.putIfAbsent("test", 123));
        Assert.assertEquals((long)123L, (long)this.map.putIfAbsent("test", 321).intValue());
        Assert.assertEquals((long)123L, (long)this.map.putIfAbsent("test", 456).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void putIfAbsentWrongKey() {
        this.map.putIfAbsent("test2", 321);
    }

    @Test
    public void computeIfAbsent() {
        Assert.assertEquals((long)123L, (long)this.map.computeIfAbsent("test", k -> 123).intValue());
        Assert.assertEquals((long)123L, (long)this.map.computeIfAbsent("test", k -> 321).intValue());
        Assert.assertEquals((long)123L, (long)this.map.computeIfAbsent("test", k -> 456).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void computeIfAbsentWrongKey() {
        this.map.computeIfAbsent("test2", k -> 123);
    }

    @Test
    public void computeIfPresent() {
        Assert.assertNull((Object)this.map.computeIfPresent("test", (k, v) -> v + 1));
        this.map.put("test", 123);
        Assert.assertEquals((Object)124, (Object)this.map.computeIfPresent("test", (k, v) -> v + 1));
        Assert.assertNull((Object)this.map.computeIfPresent("test2", (k, v) -> v + 1));
        Assert.assertNull((Object)this.map.computeIfPresent("test3", (k, v) -> 321));
    }

    @Test
    public void compute() {
        Assert.assertEquals((long)123L, (long)this.map.compute("test", (k, v) -> v == null ? 123 : v + 1).intValue());
        Assert.assertEquals((long)124L, (long)this.map.compute("test", (k, v) -> v == null ? 123 : v + 1).intValue());
        Assert.assertEquals((long)125L, (long)this.map.compute("test", (k, v) -> v == null ? 123 : v + 1).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void computeWrongKey() {
        this.map.compute("test2", (k, v) -> 123);
    }

    @Test
    public void merge() {
        Assert.assertEquals((long)1L, (long)this.map.merge("test", 1, Integer::sum).intValue());
        Assert.assertEquals((long)2L, (long)this.map.merge("test", 1, Integer::sum).intValue());
        Assert.assertEquals((long)3L, (long)this.map.merge("test", 1, Integer::sum).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void mergeWrongKey() {
        this.map.merge("test2", 123, (oldV, newV) -> oldV + newV);
    }

    @Test
    public void replace() {
        Assert.assertNull((Object)this.map.replace("test", 123));
        Assert.assertNull((Object)this.map.replace("test", 321));
        Assert.assertNull((Object)this.map.replace("test2", 123));
        this.map.put("test", 123);
        Assert.assertEquals((long)123L, (long)this.map.replace("test", 321).intValue());
        Assert.assertEquals((long)321L, (long)this.map.replace("test", 123).intValue());
        Assert.assertNull((Object)this.map.replace("test2", 123));
    }

    @Test
    public void replaceWithValue() {
        Assert.assertFalse((boolean)this.map.replace("test", 321, 123));
        Assert.assertFalse((boolean)this.map.replace("test", null, 123));
        Assert.assertFalse((boolean)this.map.replace("test2", null, 123));
        this.map.put("test", 123);
        Assert.assertTrue((boolean)this.map.replace("test", 123, 321));
        Assert.assertTrue((boolean)this.map.replace("test", 321, 456));
        Assert.assertFalse((boolean)this.map.replace("test", 321, 456));
        Assert.assertFalse((boolean)this.map.replace("test", null, 123));
        Assert.assertFalse((boolean)this.map.replace("test2", null, 123));
        Assert.assertFalse((boolean)this.map.replace("test2", 456, 123));
    }

    @Test
    public void removeWithValue() {
        Assert.assertFalse((boolean)this.map.remove("test", null));
        Assert.assertFalse((boolean)this.map.remove("test", 123));
        Assert.assertFalse((boolean)this.map.remove("test2", null));
        Assert.assertFalse((boolean)this.map.remove("test2", 123));
        this.map.put("test", 123);
        Assert.assertFalse((boolean)this.map.remove("test", null));
        Assert.assertFalse((boolean)this.map.remove("test", 321));
        Assert.assertFalse((boolean)this.map.remove("test2", null));
        Assert.assertFalse((boolean)this.map.remove("test2", 123));
        Assert.assertTrue((boolean)this.map.remove("test", 123));
        Assert.assertFalse((boolean)this.map.remove("test", 123));
    }
}

