/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.MockQueryRouter;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SelectQueryPrefetchRouterAction;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
@Deprecated
public class SelectQueryPrefetchRouterActionIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testPaintings1() {
        ObjEntity paintingEntity = this.resolver.getObjEntity(Painting.class);
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", (Object)"abc"));
        q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        SelectQueryPrefetchRouterAction action = new SelectQueryPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(q, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertSame((Object)paintingEntity, (Object)prefetch.getRoot());
        Assert.assertEquals((Object)ExpressionFactory.exp("db:toArtist.ARTIST_NAME = 'abc'", new Object[0]), (Object)prefetch.getQualifier());
    }

    @Test
    public void testPrefetchPaintings2() {
        ObjEntity paintingEntity = this.resolver.getObjEntity(Painting.class);
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.exp("artistName = 'abc' or artistName = 'xyz'", new Object[0]));
        q.addPrefetch(Artist.PAINTING_ARRAY.disjoint());
        SelectQueryPrefetchRouterAction action = new SelectQueryPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(q, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertSame((Object)paintingEntity, (Object)prefetch.getRoot());
        Assert.assertEquals((Object)ExpressionFactory.exp("db:toArtist.ARTIST_NAME = 'abc' or db:toArtist.ARTIST_NAME = 'xyz'", new Object[0]), (Object)prefetch.getQualifier());
    }

    @Test
    public void testGalleries() {
        ObjEntity galleryEntity = this.resolver.getObjEntity(Gallery.class);
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class, ExpressionFactory.matchExp("artistName", (Object)"abc"));
        q.addPrefetch("paintingArray.toGallery");
        SelectQueryPrefetchRouterAction action = new SelectQueryPrefetchRouterAction();
        MockQueryRouter router = new MockQueryRouter();
        action.route(q, router, this.resolver);
        Assert.assertEquals((long)1L, (long)router.getQueryCount());
        PrefetchSelectQuery prefetch = (PrefetchSelectQuery)router.getQueries().get(0);
        Assert.assertSame((Object)galleryEntity, (Object)prefetch.getRoot());
        Assert.assertEquals((Object)ExpressionFactory.exp("db:paintingArray.toArtist.ARTIST_NAME = 'abc'", new Object[0]), (Object)prefetch.getQualifier());
    }
}

