/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.lob.ClobTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lob.xml")
public class SelectQueryClobIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    private void createClobDataSet() throws Exception {
        TableHelper tClobTest = new TableHelper(this.dbHelper, "CLOB_TEST");
        tClobTest.setColumns(new String[]{"CLOB_TEST_ID", "CLOB_COL"});
        tClobTest.deleteAll();
        tClobTest.insert(new Object[]{1, "clob1"});
        tClobTest.insert(new Object[]{2, "clob2"});
    }

    @Test
    public void testSelectLikeIgnoreCaseClob() throws Exception {
        if (this.accessStackAdapter.supportsLobs()) {
            this.createClobDataSet();
            List objects = ObjectSelect.query(ClobTestEntity.class).where(ClobTestEntity.CLOB_COL.likeIgnoreCase("clob%")).select(this.context);
            Assert.assertEquals((long)2L, (long)objects.size());
        }
    }

    @Test
    public void testSelectFetchLimit_Offset_DistinctClob() throws Exception {
        if (this.accessStackAdapter.supportsLobs()) {
            this.createClobDataSet();
            List objects = ObjectSelect.query(ClobTestEntity.class).orderBy("db:CLOB_TEST_ID", SortOrder.ASCENDING).limit(1).offset(1).select(this.context);
            Assert.assertEquals((long)1L, (long)objects.size());
            Assert.assertEquals((long)2L, (long)Cayenne.intPKForObject((Persistent)objects.get(0)));
        }
    }

    @Test
    public void testSelectEqualsClob() throws Exception {
        if (this.accessStackAdapter.supportsLobComparisons()) {
            this.createClobDataSet();
            List objects = ObjectSelect.query(ClobTestEntity.class).where(ClobTestEntity.CLOB_COL.eq("clob1")).select(this.context);
            Assert.assertEquals((long)1L, (long)objects.size());
        }
    }

    @Test
    public void testSelectNotEqualsClob() throws Exception {
        if (this.accessStackAdapter.supportsLobComparisons()) {
            this.createClobDataSet();
            List objects = ObjectSelect.query(ClobTestEntity.class).where(ClobTestEntity.CLOB_COL.ne("clob1")).select(this.context);
            Assert.assertEquals((long)1L, (long)objects.size());
        }
    }
}

