/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectSelect_AggregateIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.US);

    @Before
    public void createArtistsDataSet() throws Exception {
        int i;
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        tArtist.setColumnTypes(new int[]{4, 12, 91});
        Date[] dates = new Date[5];
        for (i = 1; i <= 5; ++i) {
            dates[i - 1] = new Date(this.dateFormat.parse("1/" + i + "/17").getTime());
        }
        for (i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, dates[i % 5]});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i2 = 1; i2 <= 20; ++i2) {
            tPaintings.insert(new Object[]{i2, "painting" + i2, i2 % 5 + 1, 1});
        }
        tPaintings.insert(new Object[]{21, "painting21", 2, 1});
    }

    @After
    public void clearArtistsDataSet() throws Exception {
        for (String table : Arrays.asList("PAINTING", "ARTIST", "GALLERY")) {
            TableHelper tHelper = new TableHelper(this.dbHelper, table);
            tHelper.deleteAll();
        }
    }

    @Test
    public void testCount() {
        long count = (Long)ObjectSelect.query(Artist.class).column(PropertyFactory.COUNT).selectOne(this.context);
        Assert.assertEquals((long)20L, (long)count);
    }

    @Test
    public void testCountDistinct() throws Exception {
        List artists = ObjectSelect.query(Artist.class).select(this.context);
        for (Artist artist : artists) {
            artist.setArtistName("Duplicate");
        }
        this.context.commitChanges();
        NumericProperty<Long> countDistinctProp = Artist.ARTIST_NAME.countDistinct();
        long count = (Long)ObjectSelect.query(Artist.class).column(countDistinctProp).selectOne(this.context);
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @Ignore(value="Not all databases support AVG(DATE) aggregation")
    public void testAvg() throws Exception {
        BaseProperty<java.util.Date> avgProp = PropertyFactory.createBase(FunctionExpressionFactory.avgExp(Artist.DATE_OF_BIRTH.getExpression()), java.util.Date.class);
        java.util.Date avg = (java.util.Date)ObjectSelect.query(Artist.class).column(avgProp).selectOne(this.context);
        java.util.Date date = this.dateFormat.parse("1/3/17");
        Assert.assertEquals((Object)date, (Object)avg);
    }

    @Test
    public void testMin() throws Exception {
        java.util.Date avg = (java.util.Date)ObjectSelect.query(Artist.class).column(Artist.DATE_OF_BIRTH.min()).selectOne(this.context);
        java.util.Date date = this.dateFormat.parse("1/1/17");
        Assert.assertEquals((Object)date, (Object)avg);
    }

    @Test
    public void testMax() throws Exception {
        java.util.Date avg = (java.util.Date)ObjectSelect.query(Artist.class).column(Artist.DATE_OF_BIRTH.max()).selectOne(this.context);
        java.util.Date date = this.dateFormat.parse("1/5/17");
        Assert.assertEquals((Object)date, (Object)avg);
    }

    @Test
    public void testCountGroupBy() throws Exception {
        List count = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME.count(), Artist.DATE_OF_BIRTH).orderBy(Artist.DATE_OF_BIRTH.asc()).select(this.context);
        java.util.Date date = this.dateFormat.parse("1/2/17");
        Assert.assertEquals((long)5L, (long)count.size());
        Assert.assertEquals((Object)4L, (Object)((Object[])count.get(1))[0]);
        Assert.assertEquals((Object)date, (Object)((Object[])count.get(1))[1]);
    }

    @Test
    public void testSelectRelationshipCount() throws Exception {
        long count = (Long)ObjectSelect.query(Artist.class).column(Artist.PAINTING_ARRAY.count()).where(Artist.ARTIST_NAME.eq("artist1")).selectOne(this.context);
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void testSelectRelationshipCountWithAnotherField() throws Exception {
        Object[] result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.count()).where(Artist.ARTIST_NAME.eq("artist1")).selectOne(this.context);
        Assert.assertEquals((Object)"artist1", (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }
}

