/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntityPropertyTest {
    private EntityProperty<Artist> property;
    private EntityProperty<Artist> property1;

    @Before
    public void createProperty() {
        this.property = new EntityProperty<Artist>("path", null, Artist.class);
        this.property1 = new EntityProperty<Artist>("path.artist", null, Artist.class);
    }

    @Test
    public void alias() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        this.property = this.property.alias("alias");
        Assert.assertEquals((Object)"alias", (Object)this.property.getName());
        Assert.assertEquals((long)1L, (long)this.property.getExpression().getPathAliases().size());
        Assert.assertEquals((Object)"path.artist", (Object)this.property1.getName());
        this.property1 = this.property1.alias("a");
        Assert.assertEquals((Object)"path.a", (Object)this.property1.getName());
        Assert.assertEquals((long)1L, (long)this.property1.getExpression().getPathAliases().size());
        Assert.assertEquals((Object)"artist", (Object)this.property1.getExpression().getPathAliases().get("a"));
    }

    @Test
    public void outer() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path"), (Object)this.property.getExpression());
        this.property = this.property.outer();
        Assert.assertEquals((Object)"path+", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path+"), (Object)this.property.getExpression());
        this.property = this.property.outer();
        Assert.assertEquals((Object)"path+", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path+"), (Object)this.property.getExpression());
    }

    @Test
    public void dot() {
        BaseProperty<Object> other = this.property.dot("other");
        Assert.assertEquals((Object)"path.other", (Object)other.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path.other"), (Object)other.getExpression());
    }
}

