/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LikeNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;
import org.apache.cayenne.dba.mysql.sqltree.MysqlLikeNode;
import org.apache.cayenne.dba.mysql.sqltree.MysqlLimitOffsetNode;

public class MySQLTreeProcessor
extends BaseSQLTreeProcessor {
    private static final MySQLTreeProcessor INSTANCE = new MySQLTreeProcessor();

    public static MySQLTreeProcessor getInstance() {
        return INSTANCE;
    }

    private MySQLTreeProcessor() {
    }

    @Override
    protected void onLikeNode(Node parent, LikeNode child, int index) {
        if (!child.isIgnoreCase()) {
            this.replaceChild(parent, index, new MysqlLikeNode(child.isNot(), child.getEscape()));
        }
    }

    @Override
    protected void onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        MysqlLimitOffsetNode replacement = new MysqlLimitOffsetNode(child.getLimit(), child.getOffset());
        this.replaceChild(parent, index, replacement, false);
    }

    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        String functionName = child.getFunctionName();
        if ("DAY_OF_MONTH".equals(functionName) || "DAY_OF_WEEK".equals(functionName) || "DAY_OF_YEAR".equals(functionName)) {
            FunctionNode replacement = new FunctionNode(functionName.replace("_", ""), child.getAlias(), true);
            this.replaceChild(parent, index, replacement);
        }
    }
}

