/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.ingres;

import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OffsetFetchNextNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TrimmingColumnNode;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;

public class IngressSQLTreeProcessor
extends BaseSQLTreeProcessor {
    @Override
    protected void onColumnNode(Node parent, ColumnNode child, int index) {
        this.replaceChild(parent, index, new TrimmingColumnNode(child));
    }

    @Override
    protected void onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        this.replaceChild(parent, index, new OffsetFetchNextNode(child){

            @Override
            public QuotingAppendable append(QuotingAppendable buffer) {
                if (this.offset > 0) {
                    buffer.append("OFFSET ").append(this.offset);
                }
                if (this.limit > 0) {
                    buffer.append("FETCH NEXT ").append(this.limit).append(" ROWS ONLY");
                }
                return buffer;
            }
        });
    }

    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        switch (child.getFunctionName()) {
            case "CONCAT": {
                this.replaceChild(parent, index, new OpExpressionNode("+"));
                return;
            }
            case "LOCATE": {
                Node child0 = child.getChild(0);
                child.replaceChild(0, child.getChild(1));
                child.replaceChild(1, child0);
                return;
            }
            case "SUBSTRING": {
                FunctionNode replacement = new FunctionNode("SUBSTRING", child.getAlias(), true){

                    @Override
                    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
                        if (childIdx == 1 || childIdx == 2) {
                            buffer.append(" AS INTEGER)");
                        }
                        if (childIdx == 0 || childIdx == 1) {
                            buffer.append(", CAST(");
                        }
                    }

                    @Override
                    public void appendChildrenEnd(QuotingAppendable buffer) {
                        buffer.append(" AS INTEGER)");
                        super.appendChildrenEnd(buffer);
                    }
                };
                this.replaceChild(parent, index, replacement);
                return;
            }
            case "TRIM": {
                this.replaceChild(parent, index, new FunctionNode("RTRIM(LTRIM", child.getAlias(), true){

                    @Override
                    public void appendChildrenEnd(QuotingAppendable buffer) {
                        buffer.append(')');
                        super.appendChildrenEnd(buffer);
                    }
                });
                return;
            }
            case "DAY_OF_WEEK": 
            case "DAY_OF_MONTH": 
            case "DAY_OF_YEAR": {
                this.replaceChild(parent, index, new FunctionNode(child.getFunctionName().replace("_", ""), child.getAlias(), true));
                return;
            }
        }
    }
}

