/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.QualifierTranslationStage;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QualifierTranslationStageTest {
    private TranslatorContext context;

    @Before
    public void prepareContext() {
        DbEntity dbEntity = new DbEntity();
        dbEntity.setName("mock");
        DbAttribute dbAttribute = new DbAttribute();
        dbAttribute.setName("path");
        dbEntity.addAttribute(dbAttribute);
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withQualifier(ExpressionFactory.greaterOrEqualDbExp("path", 10)).withMetaData(new MockQueryMetadataBuilder().withDbEntity(dbEntity).build()).build();
        this.context = new MockTranslatorContext(wrapper);
    }

    @Test
    public void perform() {
        QualifierTranslationStage stage = new QualifierTranslationStage();
        stage.perform(this.context);
        Assert.assertNotNull((Object)this.context.getQualifierNode());
        Node op = this.context.getQualifierNode();
        Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(OpExpressionNode.class));
        Assert.assertEquals((Object)">=", (Object)((OpExpressionNode)op).getOp());
        Assert.assertEquals((long)2L, (long)op.getChildrenCount());
        Assert.assertThat((Object)op.getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)op.getChild(1), (Matcher)CoreMatchers.instanceOf(ValueNode.class));
        ColumnNode columnNode = (ColumnNode)op.getChild(0);
        ValueNode valueNode = (ValueNode)op.getChild(1);
        Assert.assertEquals((Object)"path", (Object)columnNode.getColumn());
        Assert.assertEquals((Object)10, (Object)valueNode.getValue());
    }
}

