/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.util.Collections;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyBase;
import org.apache.cayenne.access.dbsync.ThrowOnPartialSchemaStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-sus.xml")
public class ThrowOnPartialSchemaStrategyIT
extends SchemaUpdateStrategyBase {
    @Test
    public void testThrowOnPartialStrategyTableNoExist() throws Exception {
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        this.setStrategy(ThrowOnPartialSchemaStrategy.class);
        try {
            this.node.performQueries(Collections.singletonList(query), observer);
        }
        catch (CayenneRuntimeException e) {
            Assert.assertNotNull((Object)e);
        }
        try {
            this.node.performQueries(Collections.singletonList(query), observer);
        }
        catch (CayenneRuntimeException e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testThrowOnPartialStrategyTableExist() throws Exception {
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        this.createOneTable("SUS1");
        this.createOneTable("SUS2");
        this.setStrategy(ThrowOnPartialSchemaStrategy.class);
        this.node.performQueries(Collections.singletonList(query), observer);
    }

    @Test
    public void testThrowOnPartialStrategyWithOneTable() throws Exception {
        this.createOneTable("SUS1");
        this.setStrategy(ThrowOnPartialSchemaStrategy.class);
        String template = "SELECT #result('ARTIST_ID' 'int') FROM ARTIST ORDER BY ARTIST_ID";
        SQLTemplate query = new SQLTemplate(Object.class, template);
        MockOperationObserver observer = new MockOperationObserver();
        try {
            this.node.performQueries(Collections.singletonList(query), observer);
            Assert.assertEquals((long)1L, (long)this.existingTables().size());
            Assert.fail((String)"Must have thrown on partial schema");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }
}

