/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.relationships_child_master.Child;
import org.apache.cayenne.testdo.relationships_child_master.Master;
import org.apache.cayenne.unit.di.server.ServerCaseContextsSync;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-child-master.xml")
public class NestedDataContextParentPeerEventsIT
extends ServerCaseContextsSync {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DataContext parentContext1;
    @Inject
    private DataContext parentContext2;

    @Test
    public void testPeerObjectUpdatedSimpleProperty() throws Exception {
        Master a = this.parentContext1.newObject(Master.class);
        a.setName("X");
        this.parentContext1.commitChanges();
        Master a1 = this.parentContext2.localObject(a);
        final ObjectContext child = this.runtime.newContext(this.parentContext1);
        final Master a2 = child.localObject(a);
        a1.setName("Y");
        Assert.assertEquals((Object)"X", (Object)a2.getName());
        this.parentContext2.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((Object)"Y", (Object)a2.getName());
                Assert.assertFalse((String)"Peer data context became dirty on event processing", (boolean)child.hasChanges());
            }
        }.runTest(2000L);
    }

    @Test
    public void testPeerObjectUpdatedToOneRelationship() throws Exception {
        Master a = this.parentContext1.newObject(Master.class);
        Master altA = this.parentContext1.newObject(Master.class);
        Child p = this.parentContext1.newObject(Child.class);
        p.setMaster(a);
        a.setName("X");
        altA.setName("Y");
        this.parentContext1.commitChanges();
        Child p1 = this.parentContext2.localObject(p);
        Master altA1 = this.parentContext2.localObject(altA);
        final ObjectContext childContext1 = this.runtime.newContext(this.parentContext1);
        final Child p2 = childContext1.localObject(p);
        final Master altA2 = childContext1.localObject(altA);
        Master a2 = childContext1.localObject(a);
        p1.setMaster(altA1);
        Assert.assertSame((Object)a2, (Object)p2.getMaster());
        Assert.assertNotSame((Object)altA2, (Object)p2.getMaster());
        this.parentContext2.commitChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertSame((Object)altA2, (Object)p2.getMaster());
                Assert.assertFalse((String)"Peer data context became dirty on event processing", (boolean)childContext1.hasChanges());
            }
        }.runTest(2000L);
    }

    @Test
    public void testPeerObjectUpdatedToManyRelationship() throws Exception {
        Master a = this.parentContext1.newObject(Master.class);
        a.setName("X");
        Child px = this.parentContext1.newObject(Child.class);
        px.setMaster(a);
        Child py = this.parentContext1.newObject(Child.class);
        this.parentContext1.commitChanges();
        Child py1 = this.parentContext2.localObject(py);
        Master a1 = this.parentContext2.localObject(a);
        final ObjectContext peer2 = this.runtime.newContext(this.parentContext1);
        final Child py2 = peer2.localObject(py);
        final Master a2 = peer2.localObject(a);
        a1.addToChildren(py1);
        Assert.assertEquals((long)1L, (long)a2.getChildren().size());
        Assert.assertFalse((boolean)a2.getChildren().contains(py2));
        this.parentContext2.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertEquals((long)2L, (long)a2.getChildren().size());
                Assert.assertTrue((boolean)a2.getChildren().contains(py2));
                Assert.assertFalse((String)"Peer data context became dirty on event processing", (boolean)peer2.hasChanges());
            }
        }.runTest(2000L);
    }
}

