/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.Serializable;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQueryAction;
import org.apache.cayenne.cache.MockQueryCache;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataDomainQueryActionIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;

    @After
    public void tearDown() {
        this.runtime.getDataDomain().resetProperties();
    }

    @Test
    public void testCachedQuery() {
        DataDomain domain = this.runtime.getDataDomain();
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("sample");
        ObjectSelect<Painting> query = ObjectSelect.query(Painting.class).prefetch(Painting.TO_GALLERY.disjoint()).prefetch(Painting.TO_ARTIST.disjoint()).orderBy(Painting.PAINTING_TITLE.asc()).cacheStrategy(QueryCacheStrategy.SHARED_CACHE).pageSize(5);
        QueryCache cache = domain.queryCache;
        domain.queryCache = new MockQueryCache(){

            @Override
            public List<?> get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
                List results = factory.createObject();
                Assert.assertTrue((String)"Query cache is not serializable.", (boolean)(results instanceof Serializable));
                return null;
            }

            @Override
            public void put(QueryMetadata metadata, List results) {
                Assert.assertTrue((String)"Query cache is not serializable.", (boolean)(results instanceof Serializable));
            }
        };
        DataDomainQueryAction action = new DataDomainQueryAction(this.context, domain, query);
        action.execute();
        domain.queryCache = cache;
    }
}

