/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLFetchJoinIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryBlocker;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tGallery;
    protected TableHelper tExhibit;
    protected TableHelper tArtistExhibit;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tExhibit = new TableHelper(this.dbHelper, "EXHIBIT");
        this.tExhibit.setColumns(new String[]{"EXHIBIT_ID", "GALLERY_ID", "CLOSING_DATE", "OPENING_DATE"});
        this.tArtistExhibit = new TableHelper(this.dbHelper, "ARTIST_EXHIBIT");
        this.tArtistExhibit.setColumns(new String[]{"ARTIST_ID", "EXHIBIT_ID"});
    }

    protected void createOneFetchJoinDataSet() throws Exception {
        this.tArtist.insert(new Object[]{1, "A1"});
        this.tArtist.insert(new Object[]{2, "A2"});
        this.tArtist.insert(new Object[]{3, "A3"});
        this.tPainting.insert(new Object[]{1, 1, "P11", 3000.0});
        this.tPainting.insert(new Object[]{2, 2, "P2", 5000.0});
        this.tPainting.insert(new Object[]{3, 1, "P12", 3000.0});
    }

    protected void createMultipleFetchJoinsDataSet() throws Exception {
        this.createOneFetchJoinDataSet();
        this.tGallery.insert(new Object[]{1, "gallery1"});
        this.tGallery.insert(new Object[]{2, "gallery2"});
        long t = System.currentTimeMillis();
        this.tExhibit.insert(new Object[]{1, 1, new Date(10001L), new Date(t + 20000L)});
        this.tExhibit.insert(new Object[]{2, 1, new Date(30001L), new Date(t + 40000L)});
        this.tArtistExhibit.insert(new Object[]{1, 1});
        this.tArtistExhibit.insert(new Object[]{1, 2});
    }

    @Test
    public void testFetchJoinForOneEntity() throws Exception {
        this.createOneFetchJoinDataSet();
        String ejbql = "SELECT a FROM Artist a JOIN FETCH a.paintingArray ";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        this.queryBlocker.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)objects.size());
            for (Object object : objects) {
                Artist a = (Artist)object;
                List<Painting> list = a.getPaintingArray();
                Assert.assertNotNull(list);
                Assert.assertFalse((boolean)((ValueHolder)((Object)list)).isFault());
                for (Painting p : list) {
                    Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                    Assert.assertNotNull((Object)p.getPaintingTitle());
                }
            }
        });
    }

    @Test
    public void testSeveralFetchJoins() throws Exception {
        this.createMultipleFetchJoinsDataSet();
        String ejbql = "SELECT a FROM Artist a JOIN FETCH a.paintingArray JOIN FETCH a.artistExhibitArray WHERE a.artistName = 'A1'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        this.queryBlocker.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)1L, (long)objects.size());
            Artist a = (Artist)objects.get(0);
            Assert.assertEquals((Object)"A1", (Object)a.getArtistName());
            List<Painting> paintings = a.getPaintingArray();
            Assert.assertNotNull(paintings);
            Assert.assertFalse((boolean)((ValueHolder)((Object)paintings)).isFault());
            Assert.assertEquals((long)2L, (long)paintings.size());
            ArrayList<String> expectedPaintingsNames = new ArrayList<String>();
            expectedPaintingsNames.add("P11");
            expectedPaintingsNames.add("P12");
            for (Painting p : paintings) {
                Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                Assert.assertNotNull((Object)p.getPaintingTitle());
                Assert.assertTrue((boolean)expectedPaintingsNames.contains(p.getPaintingTitle()));
            }
            List<ArtistExhibit> exibits = a.getArtistExhibitArray();
            Assert.assertNotNull(exibits);
            Assert.assertFalse((boolean)((ValueHolder)((Object)exibits)).isFault());
            Assert.assertEquals((long)2L, (long)exibits.size());
            for (ArtistExhibit ae : exibits) {
                Assert.assertEquals((long)3L, (long)ae.getPersistenceState());
                Assert.assertNotNull((Object)ae.getObjectId());
            }
        });
    }

    @Test
    public void testSeveralEntitiesFetchJoins() throws Exception {
        this.createMultipleFetchJoinsDataSet();
        String ejbql = "SELECT DISTINCT a , g FROM Artist a JOIN FETCH a.paintingArray , Gallery g JOIN FETCH g.exhibitArray WHERE a.artistName='A1' AND g.galleryName='gallery1'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        this.queryBlocker.runWithQueriesBlocked(() -> {
            Assert.assertNotNull((Object)objects);
            Assert.assertFalse((boolean)objects.isEmpty());
            Assert.assertEquals((long)1L, (long)objects.size());
        });
    }

    @Test
    public void testSeveralEntitiesAndScalarFetchInnerJoins() throws Exception {
        this.createMultipleFetchJoinsDataSet();
        String ejbql = "SELECT DISTINCT a, a.artistName , g FROM Artist a JOIN FETCH a.paintingArray, Gallery g JOIN FETCH g.exhibitArray ORDER BY a.artistName";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        this.queryBlocker.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)2L, (long)objects.size());
            Object[] firstRow = (Object[])objects.get(0);
            Artist a = (Artist)firstRow[0];
            Assert.assertEquals((Object)"A1", (Object)a.getArtistName());
            List<Painting> paintings = a.getPaintingArray();
            Assert.assertNotNull(paintings);
            Assert.assertFalse((boolean)((ValueHolder)((Object)paintings)).isFault());
            Assert.assertEquals((long)2L, (long)paintings.size());
            ArrayList<String> expectedPaintingsNames = new ArrayList<String>();
            expectedPaintingsNames.add("P11");
            expectedPaintingsNames.add("P12");
            for (Painting p : paintings) {
                Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                Assert.assertNotNull((Object)p.getPaintingTitle());
                Assert.assertTrue((boolean)expectedPaintingsNames.contains(p.getPaintingTitle()));
            }
            String artistName = (String)firstRow[1];
            Assert.assertEquals((Object)"A1", (Object)artistName);
            Gallery g1 = (Gallery)firstRow[2];
            Assert.assertEquals((Object)"gallery1", (Object)g1.getGalleryName());
            List<Exhibit> exibits = g1.getExhibitArray();
            Assert.assertNotNull(exibits);
            Assert.assertFalse((boolean)((ValueHolder)((Object)exibits)).isFault());
            Assert.assertEquals((long)2L, (long)exibits.size());
            Object[] secondRow = (Object[])objects.get(1);
            a = (Artist)secondRow[0];
            Assert.assertEquals((Object)"A2", (Object)a.getArtistName());
            paintings = a.getPaintingArray();
            Assert.assertNotNull(paintings);
            Assert.assertFalse((boolean)((ValueHolder)((Object)paintings)).isFault());
            Assert.assertEquals((long)1L, (long)paintings.size());
            expectedPaintingsNames = new ArrayList();
            expectedPaintingsNames.add("P2");
            for (Painting p : paintings) {
                Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                Assert.assertNotNull((Object)p.getPaintingTitle());
                Assert.assertTrue((boolean)expectedPaintingsNames.contains(p.getPaintingTitle()));
            }
            artistName = (String)secondRow[1];
            Assert.assertEquals((Object)"A2", (Object)artistName);
            Gallery g2 = (Gallery)secondRow[2];
            Assert.assertEquals((Object)g1, (Object)g2);
        });
    }

    @Test
    public void testSeveralEntitiesAndScalarFetchOuterJoins() throws Exception {
        this.createMultipleFetchJoinsDataSet();
        String ejbql = "SELECT DISTINCT a, a.artistName , g FROM Artist a LEFT JOIN FETCH a.paintingArray, Gallery g LEFT JOIN FETCH g.exhibitArray ORDER BY a.artistName, g.galleryName";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        this.queryBlocker.runWithQueriesBlocked(() -> {
            Assert.assertEquals((long)6L, (long)objects.size());
            Object[] row = (Object[])objects.get(0);
            Artist a1 = (Artist)row[0];
            Assert.assertEquals((Object)"A1", (Object)a1.getArtistName());
            List<Painting> paintings = a1.getPaintingArray();
            Assert.assertNotNull(paintings);
            Assert.assertFalse((boolean)((ValueHolder)((Object)paintings)).isFault());
            Assert.assertEquals((long)2L, (long)paintings.size());
            ArrayList<String> expectedPaintingsNames = new ArrayList<String>();
            expectedPaintingsNames.add("P11");
            expectedPaintingsNames.add("P12");
            for (Painting p : paintings) {
                Assert.assertEquals((long)3L, (long)p.getPersistenceState());
                Assert.assertNotNull((Object)p.getPaintingTitle());
                Assert.assertTrue((boolean)expectedPaintingsNames.contains(p.getPaintingTitle()));
            }
            String artistName1 = (String)row[1];
            Assert.assertEquals((Object)"A1", (Object)artistName1);
            Gallery g1 = (Gallery)row[2];
            Assert.assertEquals((Object)"gallery1", (Object)g1.getGalleryName());
            List<Exhibit> exibits = g1.getExhibitArray();
            Assert.assertNotNull(exibits);
            Assert.assertFalse((boolean)((ValueHolder)((Object)exibits)).isFault());
            Assert.assertEquals((long)2L, (long)exibits.size());
            row = (Object[])objects.get(1);
            Assert.assertEquals((Object)a1, (Object)row[0]);
            Assert.assertEquals((Object)artistName1, (Object)row[1]);
            Gallery g2 = (Gallery)row[2];
            Assert.assertEquals((Object)"gallery2", (Object)g2.getGalleryName());
            exibits = g2.getExhibitArray();
            Assert.assertTrue((boolean)exibits.isEmpty());
            row = (Object[])objects.get(2);
            Artist a2 = (Artist)row[0];
            Assert.assertEquals((Object)"A2", (Object)a2.getArtistName());
            paintings = a2.getPaintingArray();
            Assert.assertNotNull(paintings);
            Assert.assertEquals((long)1L, (long)paintings.size());
            Painting p = paintings.get(0);
            Assert.assertEquals((long)3L, (long)p.getPersistenceState());
            Assert.assertNotNull((Object)p.getPaintingTitle());
            Assert.assertEquals((Object)"P2", (Object)p.getPaintingTitle());
            String artistName2 = (String)row[1];
            Assert.assertEquals((Object)"A2", (Object)artistName2);
            Assert.assertEquals((Object)g1, (Object)row[2]);
            row = (Object[])objects.get(3);
            Assert.assertEquals((Object)a2, (Object)row[0]);
            Assert.assertEquals((Object)artistName2, (Object)row[1]);
            Assert.assertEquals((Object)g2, (Object)row[2]);
            row = (Object[])objects.get(4);
            Artist a3 = (Artist)row[0];
            Assert.assertEquals((Object)"A3", (Object)a3.getArtistName());
            paintings = a3.getPaintingArray();
            Assert.assertTrue((boolean)paintings.isEmpty());
            String artistName3 = (String)row[1];
            Assert.assertEquals((Object)"A3", (Object)artistName3);
            Assert.assertEquals((Object)g1, (Object)row[2]);
            row = (Object[])objects.get(5);
            Assert.assertEquals((Object)a3, (Object)row[0]);
            Assert.assertEquals((Object)artistName3, (Object)row[1]);
            Assert.assertEquals((Object)g2, (Object)row[2]);
        });
    }
}

