/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.test.parallel.ParallelTestContainer;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCaseContextsSync;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.EventUtil;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextDataChannelEventsIT
extends ServerCaseContextsSync {
    @Inject
    private DataContext context;
    @Inject
    private DataContext peer;
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testCommitEvent() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        this.context.commitChanges();
        final MockChannelListener listener = new MockChannelListener();
        EventUtil.listenForChannelEvents(this.context, (DataChannelListener)listener);
        a.setArtistName("Y");
        this.context.commitChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertTrue((boolean)listener.graphCommitted);
                Assert.assertFalse((boolean)listener.graphChanged);
                Assert.assertFalse((boolean)listener.graphRolledBack);
            }
        }.runTest(10000L);
    }

    @Test
    public void testRollbackEvent() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        this.context.commitChanges();
        final MockChannelListener listener = new MockChannelListener();
        EventUtil.listenForChannelEvents(this.context, (DataChannelListener)listener);
        a.setArtistName("Y");
        this.context.rollbackChanges();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertFalse((boolean)listener.graphCommitted);
                Assert.assertFalse((boolean)listener.graphChanged);
                Assert.assertTrue((boolean)listener.graphRolledBack);
            }
        }.runTest(10000L);
    }

    @Test
    public void testChangeEventOnChildChange() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        this.context.commitChanges();
        final MockChannelListener listener = new MockChannelListener();
        EventUtil.listenForChannelEvents(this.context, (DataChannelListener)listener);
        ObjectContext childContext = this.runtime.newContext(this.context);
        Artist a1 = childContext.localObject(a);
        a1.setArtistName("Y");
        childContext.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertFalse((boolean)listener.graphCommitted);
                Assert.assertTrue((boolean)listener.graphChanged);
                Assert.assertFalse((boolean)listener.graphRolledBack);
            }
        }.runTest(10000L);
    }

    @Test
    public void testChangeEventOnPeerChange() throws Exception {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("X");
        this.context.commitChanges();
        final MockChannelListener listener = new MockChannelListener();
        EventUtil.listenForChannelEvents(this.context, (DataChannelListener)listener);
        Artist a1 = this.peer.localObject(a);
        a1.setArtistName("Y");
        this.peer.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertFalse((boolean)listener.graphCommitted);
                Assert.assertTrue((boolean)listener.graphChanged);
                Assert.assertFalse((boolean)listener.graphRolledBack);
            }
        }.runTest(10000L);
    }

    @Test
    public void testChangeEventOnPeerChangeSecondNestingLevel() throws Exception {
        ObjectContext childPeer1 = this.runtime.newContext(this.context);
        Artist a = childPeer1.newObject(Artist.class);
        a.setArtistName("X");
        childPeer1.commitChanges();
        final MockChannelListener listener = new MockChannelListener();
        EventUtil.listenForChannelEvents(childPeer1, (DataChannelListener)listener);
        ObjectContext childPeer2 = this.runtime.newContext(this.context);
        Artist a1 = childPeer2.localObject(a);
        a1.setArtistName("Y");
        childPeer2.commitChangesToParent();
        new ParallelTestContainer(){

            protected void assertResult() throws Exception {
                Assert.assertFalse((boolean)listener.graphCommitted);
                Assert.assertTrue((boolean)listener.graphChanged);
                Assert.assertFalse((boolean)listener.graphRolledBack);
            }
        }.runTest(10000L);
    }

    class MockChannelListener
    implements DataChannelListener {
        boolean graphChanged;
        boolean graphCommitted;
        boolean graphRolledBack;

        MockChannelListener() {
        }

        @Override
        public void graphChanged(GraphEvent event) {
            this.graphChanged = true;
        }

        @Override
        public void graphFlushed(GraphEvent event) {
            this.graphCommitted = true;
        }

        @Override
        public void graphRolledback(GraphEvent event) {
            this.graphRolledBack = true;
        }
    }
}

