/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.ToManyList;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneDataObjectRelationshipsIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tPaintingInfo;
    private TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID"});
        this.tPaintingInfo = new TableHelper(this.dbHelper, "PAINTING_INFO");
        this.tPaintingInfo.setColumns(new String[]{"PAINTING_ID", "TEXT_REVIEW"});
    }

    private void createArtistWithPaintingDataSet() throws Exception {
        this.tArtist.insert(new Object[]{8, "aX"});
        this.tPainting.insert(new Object[]{6, "pW", 8});
    }

    private void createArtistWithPaintingAndInfoDataSet() throws Exception {
        this.tArtist.insert(new Object[]{8, "aX"});
        this.tPainting.insert(new Object[]{6, "pW", 8});
        this.tPaintingInfo.insert(new Object[]{6, "mE"});
    }

    @Test
    public void testReadNestedProperty1() throws Exception {
        this.createArtistWithPaintingDataSet();
        Painting p1 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Assert.assertEquals((Object)"aX", (Object)p1.readNestedProperty("toArtist.artistName"));
    }

    @Test
    public void testReadNestedProperty2() throws Exception {
        this.createArtistWithPaintingDataSet();
        Painting p1 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Assert.assertTrue((boolean)(p1.getToArtist().readNestedProperty("paintingArray") instanceof List));
    }

    @Test
    public void testReciprocalRel1() throws Exception {
        this.createArtistWithPaintingDataSet();
        Painting p1 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Artist a1 = p1.getToArtist();
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((Object)"aX", (Object)a1.getArtistName());
        List<Painting> paintings = a1.getPaintingArray();
        Assert.assertEquals((long)1L, (long)paintings.size());
        Painting p2 = paintings.get(0);
        Assert.assertSame((Object)p1, (Object)p2);
    }

    @Test
    public void testReadToOneRel1() throws Exception {
        this.createArtistWithPaintingDataSet();
        Painting p1 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Artist a1 = p1.getToArtist();
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertEquals((Object)"aX", (Object)a1.getArtistName());
        Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
    }

    @Test
    public void testReadToOneRel2() throws Exception {
        this.createArtistWithPaintingAndInfoDataSet();
        PaintingInfo pi1 = Cayenne.objectForPK(this.context, PaintingInfo.class, 6);
        Painting p1 = pi1.getPainting();
        p1.getPaintingTitle();
        Artist a1 = p1.getToArtist();
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertEquals((Object)"aX", (Object)a1.getArtistName());
        Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
    }

    @Test
    public void testReadToOneRel3() throws Exception {
        this.createArtistWithPaintingDataSet();
        Painting p1 = Cayenne.objectForPK(this.context, Painting.class, 6);
        Gallery g1 = p1.getToGallery();
        Assert.assertNull((Object)g1);
    }

    @Test
    public void testReadToManyRel1() throws Exception {
        this.createArtistWithPaintingDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 8);
        List<Painting> plist = a1.getPaintingArray();
        Assert.assertNotNull(plist);
        Assert.assertEquals((long)1L, (long)plist.size());
        Assert.assertEquals((long)3L, (long)plist.get(0).getPersistenceState());
        Assert.assertEquals((Object)"pW", (Object)plist.get(0).getPaintingTitle());
    }

    @Test
    public void testReadToManyRel2() throws Exception {
        this.tArtist.insert(new Object[]{11, "aX"});
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 11);
        List<Painting> plist = a1.getPaintingArray();
        Assert.assertNotNull(plist);
        Assert.assertEquals((long)0L, (long)plist.size());
    }

    @Test
    public void testReflexiveRelationshipInsertOrder1() {
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        childGroup1.setToParentGroup(parentGroup);
        this.context.commitChanges();
        childGroup1.setToParentGroup(null);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipInsertOrder2() {
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        childGroup1.setToParentGroup(parentGroup);
        this.context.commitChanges();
        childGroup1.setToParentGroup(null);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipInsertOrder3() {
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        childGroup1.setToParentGroup(parentGroup);
        ArtGroup childGroup2 = this.context.newObject(ArtGroup.class);
        childGroup2.setName("child2");
        childGroup2.setToParentGroup(parentGroup);
        this.context.commitChanges();
        childGroup1.setToParentGroup(null);
        this.context.commitChanges();
        childGroup2.setToParentGroup(null);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipInsertOrder4() {
        ArtGroup childGroup1 = this.context.newObject(ArtGroup.class);
        childGroup1.setName("child1");
        ArtGroup parentGroup = this.context.newObject(ArtGroup.class);
        parentGroup.setName("parent");
        childGroup1.setToParentGroup(parentGroup);
        ArtGroup childGroup2 = this.context.newObject(ArtGroup.class);
        childGroup2.setName("subchild");
        childGroup2.setToParentGroup(childGroup1);
        this.context.commitChanges();
        childGroup1.setToParentGroup(null);
        this.context.commitChanges();
        childGroup2.setToParentGroup(null);
        this.context.commitChanges();
    }

    @Test
    public void testCrossContextRelationshipException() {
        Artist artist = this.context.newObject(Artist.class);
        Painting painting = this.runtime.newContext().newObject(Painting.class);
        try {
            painting.setToArtist(artist);
            Assert.fail((String)"Should have failed to set a cross-context relationship");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
        Assert.assertNull((Object)painting.getToArtist());
        try {
            artist.addToPaintingArray(painting);
            Assert.fail((String)"Should have failed to add a cross-context relationship");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)artist.getPaintingArray().size());
    }

    @Test
    public void testComplexInsertUpdateOrdering() {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("a name");
        this.context.commitChanges();
        Painting painting = this.context.newObject(Painting.class);
        painting.setPaintingTitle("a painting");
        artist.addToPaintingArray(painting);
        this.context.commitChanges();
        this.context.deleteObjects(artist);
        this.context.commitChanges();
    }

    @Test
    public void testNewToMany() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("test");
        Assert.assertTrue((boolean)(artist.readPropertyDirectly("paintingArray") instanceof ToManyList));
        ToManyList list = (ToManyList)artist.readPropertyDirectly("paintingArray");
        Assert.assertFalse((boolean)list.isFault());
        this.context.commitChanges();
        Assert.assertFalse((boolean)list.isFault());
    }

    @Test
    public void testTransientInsertAndDeleteOfToManyRelationship() throws Exception {
        this.createArtistWithPaintingDataSet();
        Artist artist = (Artist)ObjectSelect.query(Artist.class).selectOne(this.context);
        Painting object2 = this.context.newObject(Painting.class);
        artist.addToPaintingArray(object2);
        artist.removeFromPaintingArray(object2);
        this.context.deleteObject(object2);
        Assert.assertEquals((long)1L, (long)artist.getPaintingArray().size());
        artist.setArtistName("updated artist name");
        this.context.commitChanges();
    }

    @Test
    public void testTransientSetAndNullOfToOneRelationship() throws Exception {
        this.createArtistWithPaintingDataSet();
        Artist artist = (Artist)ObjectSelect.query(Artist.class).selectOne(this.context);
        Painting object2 = this.context.newObject(Painting.class);
        object2.setPaintingTitle("Title");
        object2.setToArtist(artist);
        object2.setToArtist(null);
        this.context.commitChanges();
        this.context.invalidateObjects(object2);
        Assert.assertNull((Object)object2.getToArtist());
    }
}

