/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.sql.Date;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class Cay2412IT
extends ServerCase {
    @Inject
    DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void prepareData() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        tArtist.setColumnTypes(new int[]{4, 12, 91});
        tArtist.insert(new Object[]{1, "artist1", new Date(System.currentTimeMillis())});
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID", "ESTIMATED_PRICE"});
        for (int i = 1; i <= 3; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, 1, 1, 22 - i});
        }
    }

    @Ignore(value="selectFirst() call corrupts object state in context, and because of cache it's also returned for unrelated query")
    @Test
    public void testJoinPrefetch() {
        Artist artist0 = (Artist)ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.joint()).localCache("test").selectOne(this.context);
        Assert.assertEquals((long)3L, (long)artist0.getPaintingArray().size());
        Artist artist1 = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.joint()).selectFirst(this.context);
        Assert.assertEquals((long)1L, (long)artist1.getPaintingArray().size());
        Artist artist2 = (Artist)ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.joint()).localCache("test").selectOne(this.context);
        Assert.assertEquals((long)3L, (long)artist2.getPaintingArray().size());
    }

    @Test
    public void testDisjointByIdPrefetch() {
        Artist artist0 = (Artist)ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjointById()).localCache("test").selectOne(this.context);
        Assert.assertEquals((long)3L, (long)artist0.getPaintingArray().size());
        Artist artist1 = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjointById()).selectFirst(this.context);
        Assert.assertEquals((long)3L, (long)artist1.getPaintingArray().size());
        Artist artist2 = (Artist)ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjointById()).localCache("test").selectOne(this.context);
        Assert.assertEquals((long)3L, (long)artist2.getPaintingArray().size());
    }
}

