/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value.json;

import org.apache.cayenne.value.json.JsonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void compare() {
        Assert.assertTrue((boolean)JsonUtils.compare("[]", "[]"));
        Assert.assertTrue((boolean)JsonUtils.compare("{}", "{}"));
        Assert.assertFalse((boolean)JsonUtils.compare("[]", "{}"));
        Assert.assertTrue((boolean)JsonUtils.compare("123", "123"));
        Assert.assertFalse((boolean)JsonUtils.compare("123", "124"));
        Assert.assertTrue((boolean)JsonUtils.compare("null", "null"));
        Assert.assertTrue((boolean)JsonUtils.compare("true", "true"));
        Assert.assertFalse((boolean)JsonUtils.compare("true", "false"));
        Assert.assertTrue((boolean)JsonUtils.compare("\"123\"", "\"123\""));
        Assert.assertFalse((boolean)JsonUtils.compare("123", "\"123\""));
        Assert.assertTrue((boolean)JsonUtils.compare("[1,2,3]", "[1, 2, 3]"));
        Assert.assertFalse((boolean)JsonUtils.compare("[1,2,3]", "[1,2,3,4]"));
        Assert.assertFalse((boolean)JsonUtils.compare("[1,2,3]", "[1,2]"));
        Assert.assertFalse((boolean)JsonUtils.compare("[1,2,3]", "[1,2,4]"));
        Assert.assertTrue((boolean)JsonUtils.compare("{\"abc\":123,\"def\":321}", " {\"def\" :  321 , \n\t\"abc\" :\t123 }"));
        Assert.assertFalse((boolean)JsonUtils.compare("{\"abc\":123}", " {\"abc\" :  124 }"));
    }

    @Test
    public void normalize() {
        Assert.assertEquals((Object)"[]", (Object)JsonUtils.normalize("[]"));
        Assert.assertEquals((Object)"{}", (Object)JsonUtils.normalize("{}"));
        Assert.assertEquals((Object)"true", (Object)JsonUtils.normalize("true"));
        Assert.assertEquals((Object)"null", (Object)JsonUtils.normalize("null"));
        Assert.assertEquals((Object)"false", (Object)JsonUtils.normalize("false"));
        Assert.assertEquals((Object)"123", (Object)JsonUtils.normalize("123"));
        Assert.assertEquals((Object)"-10.24e3", (Object)JsonUtils.normalize("-10.24e3"));
        Assert.assertEquals((Object)"\"abc\\\"def\"", (Object)JsonUtils.normalize("\"abc\\\"def\""));
        Assert.assertEquals((Object)"[1, 2.0, -0.3e3, false, null, true]", (Object)JsonUtils.normalize("[1 ,  2.0  ,-0.3e3, false,\nnull,\ttrue]"));
        Assert.assertEquals((Object)"{\"abc\": 321, \"def\": true, \"ghi\": \"jkl\"}", (Object)JsonUtils.normalize("{\"abc\":321,\n\"def\":true,\n\t\"ghi\":\"jkl\"}"));
    }
}

