/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.unit.di;

import java.util.function.Supplier;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.graph.GraphDiff;

public class CommitStats
implements DataChannelSyncFilter {
    private int commitCount;
    private Supplier<DataDomain> dataDomain;

    public CommitStats(Supplier<DataDomain> dataDomain) {
        this.dataDomain = dataDomain;
    }

    public void before() {
        this.dataDomain.get().addSyncFilter(this);
        this.commitCount = 0;
    }

    public void after() {
        this.dataDomain.get().removeSyncFilter(this);
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelSyncFilterChain filterChain) {
        switch (syncType) {
            case 2: {
                ++this.commitCount;
            }
        }
        return filterChain.onSync(originatingContext, changes, syncType);
    }

    public int getCommitCount() {
        return this.commitCount;
    }
}

