/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactoryIT;
import org.apache.cayenne.reflect.generic.DefaultValueComparisonStrategyFactory;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-inheritance-single-table1.xml")
public class DataObjectDescriptorFactory_InheritanceMapsIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testVisitProperties_IterationOrder() {
        DataObjectDescriptorFactory factory = new DataObjectDescriptorFactory(this.resolver.getClassDescriptorMap(), new SingletonFaultFactory(), new DefaultValueComparisonStrategyFactory((ValueObjectTypeRegistry)Mockito.mock(ValueObjectTypeRegistry.class)));
        for (ObjEntity e : this.resolver.getObjEntities()) {
            ClassDescriptor descriptor = factory.getDescriptor(e.getName());
            final PropertyDescriptor[] lastProcessed = new PropertyDescriptor[1];
            PropertyVisitor visitor = new PropertyVisitor(){

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    DataObjectDescriptorFactoryIT.assertPropertiesAreInOrder(lastProcessed[0], property);
                    lastProcessed[0] = property;
                    return true;
                }
            };
            descriptor.visitProperties(visitor);
        }
    }
}

