/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.reflect.LifecycleCallbackEventHandler;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleCallbackEventHandlerTest {
    @Test
    public void testDefaultListeners() {
        LifecycleCallbackEventHandler map = new LifecycleCallbackEventHandler();
        L1 l1 = new L1();
        map.addDefaultListener(l1, "callback");
        C1 c1 = new C1();
        c1.setObjectId(ObjectId.of("bogus"));
        Assert.assertEquals((long)0L, (long)l1.entities.size());
        map.performCallbacks(c1);
        Assert.assertEquals((long)1L, (long)l1.entities.size());
        Assert.assertTrue((boolean)l1.entities.contains(c1));
    }

    @Test
    public void testDefaultListenersCallbackOrder() {
        LifecycleCallbackEventHandler map = new LifecycleCallbackEventHandler();
        L2 l1 = new L2();
        map.addListener(C1.class, (Object)l1, "callback");
        L2 l2 = new L2();
        map.addDefaultListener(l2, "callback");
        C1 c1 = new C1();
        c1.setObjectId(ObjectId.of("bogus"));
        map.performCallbacks(c1);
        Assert.assertEquals((long)1L, (long)l1.callbackTimes.size());
        Assert.assertEquals((long)1L, (long)l2.callbackTimes.size());
        Long t1 = (Long)l1.callbackTimes.get(0);
        Long t2 = (Long)l2.callbackTimes.get(0);
        Assert.assertTrue((t2.compareTo(t1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCallbackOnSuperclass() {
        LifecycleCallbackEventHandler map = new LifecycleCallbackEventHandler();
        map.addListener(C1.class, "c1Callback");
        C3 subclass = new C3();
        subclass.setObjectId(ObjectId.of("bogusSubclass"));
        Assert.assertEquals((long)0L, (long)subclass.callbacks.size());
        map.performCallbacks(subclass);
        Assert.assertEquals((long)1L, (long)subclass.callbacks.size());
    }

    @Test
    public void testCallbackOnSuperclassWithSublcassOverrides() {
        LifecycleCallbackEventHandler map = new LifecycleCallbackEventHandler();
        map.addListener(C1.class, "c1Callback");
        C4 subclass = new C4();
        subclass.setObjectId(ObjectId.of("bogus"));
        Assert.assertEquals((long)0L, (long)subclass.callbacks.size());
        map.performCallbacks(subclass);
        Assert.assertEquals((long)1L, (long)subclass.callbacks.size());
        Assert.assertEquals((Object)"c4Callback", subclass.callbacks.get(0));
    }

    @Test
    public void testCallbackOrderInInheritanceHierarchy() {
        LifecycleCallbackEventHandler map = new LifecycleCallbackEventHandler();
        map.addListener(C2.class, "c2Callback");
        map.addListener(C1.class, "c1Callback");
        C2 c = new C2();
        c.setObjectId(ObjectId.of("bogus"));
        Assert.assertTrue((boolean)c.callbacks.isEmpty());
        map.performCallbacks(c);
        Assert.assertEquals((long)2L, (long)c.callbacks.size());
        Assert.assertEquals((Object)"c1Callback", c.callbacks.get(0));
        Assert.assertEquals((Object)"c2Callback", c.callbacks.get(1));
    }

    static class L2 {
        protected List callbackTimes = new ArrayList();

        L2() {
        }

        void callback(Object entity) {
            this.callbackTimes.add(new Long(System.currentTimeMillis()));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class L1 {
        protected List entities = new ArrayList();

        L1() {
        }

        void callback(Object entity) {
            this.entities.add(entity);
        }
    }

    static class C4
    extends C1 {
        C4() {
        }

        @Override
        void c1Callback() {
            this.callbacks.add("c4Callback");
        }
    }

    static class C3
    extends C1 {
        C3() {
        }
    }

    static class C2
    extends C1 {
        C2() {
        }

        void c2Callback() {
            this.callbacks.add("c2Callback");
        }
    }

    static class C1
    extends PersistentObject {
        protected List callbacks = new ArrayList();

        C1() {
        }

        void c1Callback() {
            this.callbacks.add("c1Callback");
        }
    }
}

