/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLTemplateIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    @Inject
    protected UnitDbAdapter unitDbAdapter;
    private TableHelper tPainting;
    private TableHelper tArtist;
    private TableHelper tArtistCt;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"});
        this.tArtistCt = new TableHelper(this.dbHelper, "ARTIST_CT");
        this.tArtistCt.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
    }

    private void createArtistDataSet() throws SQLException {
        this.tArtist.insert(new Object[]{15, "Surikov", new Date(System.currentTimeMillis())});
        this.tArtist.insert(new Object[]{16, "Ivanov", new Date(System.currentTimeMillis())});
    }

    @Test
    public void testSQLTemplateForDataMap() {
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q1 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", true);
        List result = this.context.performQuery(q1);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testSQLTemplateForDataMapWithInsert() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q2 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", true);
        List result = this.context.performQuery(q2);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testReturnGeneratedKeys() {
        if (this.unitDbAdapter.supportsGeneratedKeys()) {
            DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
            String sql = "INSERT INTO GENERATED_COLUMN (NAME) VALUES ('Surikov')";
            SQLTemplate q1 = new SQLTemplate(testDataMap, sql, true);
            q1.setReturnGeneratedKeys(true);
            List response = this.context.performQuery(q1);
            Assert.assertEquals((long)1L, (long)response.size());
            String sql1 = "INSERT INTO GENERATED_COLUMN (NAME) VALUES ('Test')";
            SQLTemplate q2 = new SQLTemplate(testDataMap, sql1, true);
            q2.setReturnGeneratedKeys(false);
            List response1 = this.context.performQuery(q2);
            Assert.assertEquals((long)0L, (long)response1.size());
        }
    }

    @Test
    public void testSQLTemplateForDataMapWithInsertException() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q2 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", false);
        boolean gotRuntimeException = false;
        try {
            this.context.performQuery(q2);
        }
        catch (CayenneRuntimeException e) {
            gotRuntimeException = true;
        }
        Assert.assertTrue((String)"If fetchingDataRows is false and ObjectEntity not set, should be thrown exception", (boolean)gotRuntimeException);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testExceptionWhenUsingColumnsTypesAndSQLResult() throws SQLException {
        this.createArtistDataSet();
        SQLTemplate query = new SQLTemplate("SELECT ARTIST_ID P FROM ARTIST", true);
        query.setResultColumnsTypes(Float.class);
        SQLResult resultDescriptor = new SQLResult();
        resultDescriptor.addColumnResult("P");
        query.setResult(resultDescriptor);
        this.context.performQuery(query);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testExceptionWhenUsingColumnsTypesAndSQLResultUsingScalar() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate query = new SQLTemplate(testDataMap, "SELECT ARTIST_ID, ARTIST_NAME P FROM ARTIST", false);
        query.setResultColumnsTypes(Float.class, String.class);
        query.setUseScalar(true);
        SQLResult resultDescriptor = new SQLResult();
        resultDescriptor.addColumnResult("P");
        resultDescriptor.addColumnResult("N");
        query.setResult(resultDescriptor);
        this.context.performQuery(query);
    }

    @Test
    public void testWithRootUsingScalar() throws SQLException {
        this.createArtistDataSet();
        SQLTemplate q3 = new SQLTemplate(Artist.class, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST");
        q3.setResultColumnsTypes(Double.class, String.class);
        q3.setUseScalar(true);
        List result = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Object[]));
        Assert.assertTrue((boolean)(((Object[])result.get(0))[0] instanceof Double));
    }

    @Test
    public void testWithRootUsingDataRow() throws SQLException {
        this.createArtistDataSet();
        SQLTemplate q3 = new SQLTemplate(Artist.class, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST");
        q3.setResultColumnsTypes(Double.class, String.class);
        q3.setFetchingDataRows(true);
        q3.setColumnNamesCapitalization(CapsStrategy.UPPER);
        List result = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DataRow));
        Assert.assertThat(((DataRow)result.get(0)).get("ARTIST_ID"), (Matcher)CoreMatchers.instanceOf(Double.class));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testWithRootException() throws SQLException {
        this.createArtistDataSet();
        SQLTemplate q3 = new SQLTemplate(Artist.class, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST");
        q3.setResultColumnsTypes(Double.class, String.class);
        this.context.performQuery(q3);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testUsingScalarAndDataRow() throws SQLException {
        this.createArtistDataSet();
        SQLTemplate q3 = new SQLTemplate(Artist.class, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST");
        q3.setUseScalar(true);
        q3.setFetchingDataRows(true);
        this.context.performQuery(q3);
    }

    @Test
    public void testDataRowWithTypes() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST", true);
        q3.setResultColumnsTypes(Double.class, String.class);
        q3.setColumnNamesCapitalization(CapsStrategy.UPPER);
        List artists = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertTrue((boolean)(artists.get(0) instanceof DataRow));
        Assert.assertThat(((DataRow)artists.get(0)).get("ARTIST_ID"), (Matcher)CoreMatchers.instanceOf(Double.class));
    }

    @Test
    public void testDataRowReturnAndDirectives() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT #result('ARTIST_ID' 'java.lang.Long'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST", true);
        List result = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DataRow));
        Assert.assertEquals((long)2L, (long)((DataRow)result.get(0)).size());
        Assert.assertTrue((boolean)(((DataRow)result.get(0)).get("ARTIST_ID") instanceof Long));
        Assert.assertTrue((boolean)(((DataRow)result.get(0)).get("ARTIST_NAME") instanceof String));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testDataRowReturnAndDirectivesExc() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT #result('ARTIST_ID' 'java.lang.Long'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST", true);
        q3.setResultColumnsTypes(Integer.class, String.class);
        this.context.performQuery(q3);
    }

    @Test
    public void testObjectArrayReturnAndDirectives() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT #result('ARTIST_ID' 'java.lang.Long'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST", false);
        q3.setUseScalar(true);
        List result = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Object[]));
        Assert.assertEquals((long)2L, (long)((Object[])result.get(0)).length);
        Assert.assertTrue((boolean)(((Object[])result.get(0))[0] instanceof Long));
        Assert.assertTrue((boolean)(((Object[])result.get(0))[1] instanceof String));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testObjectArrayReturnAndDirectivesException() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT #result('ARTIST_ID' 'java.lang.Long'), #result('ARTIST_NAME' 'java.lang.String') FROM ARTIST", false);
        q3.setResultColumnsTypes(Integer.class, String.class);
        q3.setUseScalar(true);
        this.context.performQuery(q3);
    }

    @Test
    public void testObjectArrayWithSingleObjectReturnAndDirectives() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT #result('ARTIST_ID' 'java.lang.Long') FROM ARTIST", false);
        q3.setUseScalar(true);
        List result = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Object[]));
        Assert.assertEquals((long)1L, (long)((Object[])result.get(0)).length);
        Assert.assertTrue((boolean)(((Object[])result.get(0))[0] instanceof Long));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testObjectArrayReturnWithException() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST", false);
        q3.setResultColumnsTypes(Integer.class);
        q3.setUseScalar(true);
        this.context.performQuery(q3);
    }

    @Test
    public void testObjectArrayWithSingleObjectReturn() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT ARTIST_ID FROM ARTIST", false);
        q3.setUseScalar(true);
        List artists = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertEquals((long)1L, (long)((Object[])artists.get(0)).length);
        Assert.assertTrue((boolean)(artists.get(0) instanceof Object[]));
        Assert.assertTrue((boolean)(((Object[])artists.get(0))[0] instanceof Long));
    }

    @Test
    public void testObjectArrayReturnWithDefaultTypes() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q3 = new SQLTemplate(testDataMap, "SELECT ARTIST_ID, ARTIST_NAME FROM ARTIST", false);
        q3.setUseScalar(true);
        List artists = this.context.performQuery(q3);
        Assert.assertEquals((long)2L, (long)artists.size());
        Assert.assertEquals((long)2L, (long)((Object[])artists.get(0)).length);
        Assert.assertTrue((boolean)(artists.get(0) instanceof Object[]));
        Assert.assertTrue((boolean)(((Object[])artists.get(0))[0] instanceof Long));
    }

    @Test
    public void testObjectArrayReturn() throws SQLException {
        this.createArtistDataSet();
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q5 = new SQLTemplate(testDataMap, "SELECT * FROM ARTIST", false);
        q5.setResultColumnsTypes(Float.class, String.class, LocalDateTime.class);
        q5.setUseScalar(true);
        List dates = this.context.performQuery(q5);
        Assert.assertEquals((long)2L, (long)dates.size());
        Assert.assertTrue((boolean)(dates.get(0) instanceof Object[]));
        Assert.assertEquals((long)3L, (long)((Object[])dates.get(0)).length);
        Assert.assertTrue((boolean)(((Object[])dates.get(0))[2] instanceof LocalDateTime));
    }

    @Test
    public void testSingleObjectReturn() throws SQLException {
        this.tArtistCt.insert(new Object[]{1, "Test", new Date(System.currentTimeMillis())});
        DataMap testDataMap = this.context.getEntityResolver().getDataMap("testmap");
        SQLTemplate q5 = new SQLTemplate(testDataMap, "SELECT ARTIST_NAME FROM ARTIST_CT", false);
        q5.setResultColumnsTypes(String.class);
        q5.setUseScalar(true);
        List dates = this.context.performQuery(q5);
        Assert.assertEquals((long)1L, (long)dates.size());
        Assert.assertTrue((boolean)(dates.get(0) instanceof String));
        Assert.assertEquals((Object)"Test", dates.get(0));
    }

    @Test
    public void testSQLTemplate_PositionalParams() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($c 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(76, "The Fiddler", 10005);
        this.context.performNonSelectingQuery(q1);
        Assert.assertEquals((Object)"The Fiddler", (Object)this.tPainting.getString("PAINTING_TITLE"));
        Assert.assertEquals((long)76L, (long)this.tPainting.getInt("PAINTING_ID"));
        Assert.assertEquals((double)10005.0, (double)this.tPainting.getDouble("ESTIMATED_PRICE"), (double)0.001);
    }

    @Test
    public void testSQLTemplate_PositionalParams_RepeatingVars() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($b 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(11, "The Fiddler");
        this.context.performNonSelectingQuery(q1);
        Assert.assertEquals((Object)"The Fiddler", (Object)this.tPainting.getString("PAINTING_TITLE"));
        Assert.assertEquals((long)11L, (long)this.tPainting.getInt("PAINTING_ID"));
        Assert.assertEquals((double)11.0, (double)this.tPainting.getDouble("ESTIMATED_PRICE"), (double)0.001);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testSQLTemplate_PositionalParams_ToFewParams() {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($c 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(11, "The Fiddler");
        this.context.performNonSelectingQuery(q1);
    }

    @Test
    public void testSQLTemplate_PositionalParams_ToManyParams() throws SQLException {
        String sql = "INSERT INTO PAINTING (PAINTING_ID, PAINTING_TITLE, ESTIMATED_PRICE) VALUES ($b, '$n', #bind($b 'INTEGER'))";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.setParamsArray(11, "The Fiddler", 2345, 333);
        try {
            this.context.performNonSelectingQuery(q1);
            Assert.fail((String)"Exception not thrown on parameter length mismatch");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSQLTemplateSelectNullObjects() throws Exception {
        this.tPainting.insert(new Object[]{1, null, "p1", 10});
        String sql = "SELECT p.GALLERY_ID FROM PAINTING p";
        SQLTemplate q1 = new SQLTemplate(Gallery.class, sql);
        q1.setColumnNamesCapitalization(CapsStrategy.UPPER);
        List galleries = this.context.performQuery(q1);
        Assert.assertEquals((long)1L, (long)galleries.size());
        Assert.assertNull(galleries.get(0));
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testSQLTemplateSelectInvalid() throws Exception {
        this.tPainting.insert(new Object[]{1, null, "p1", 10});
        String sql = "SELECT p.PAINTING_TITLE FROM PAINTING p";
        SQLTemplate q1 = new SQLTemplate(Gallery.class, sql);
        q1.setColumnNamesCapitalization(CapsStrategy.UPPER);
        this.context.performQuery(q1);
    }

    @Test
    public void testSQLTemplateWithDisjointByIdPrefetch() throws Exception {
        this.tArtist.insert(new Object[]{1, "artist1", null});
        this.tArtist.insert(new Object[]{2, "artist2", null});
        this.tPainting.insert(new Object[]{1, 1, "p1", 10});
        this.tPainting.insert(new Object[]{2, 2, "p2", 20});
        String sql = "SELECT p.* FROM PAINTING p";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.addPrefetch(Painting.TO_ARTIST.disjointById());
        q1.setColumnNamesCapitalization(CapsStrategy.UPPER);
        List paintings = this.context.performQuery(q1);
        this.queryInterceptor.runWithQueriesBlocked(() -> {
            for (Painting painting : paintings) {
                Assert.assertEquals((long)3L, (long)painting.getToArtist().getPersistenceState());
            }
        });
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testSQLTemplateWithDisjointPrefetch() {
        String sql = "SELECT p.* FROM PAINTING p";
        SQLTemplate q1 = new SQLTemplate(Painting.class, sql);
        q1.addPrefetch(Painting.TO_ARTIST.disjoint());
    }
}

