/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectSelect_SubqueryIT
extends ServerCase {
    @Inject
    DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis() - 172800000L;
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(86400000 * i))});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i = 1; i <= 20; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, i % 5 + 1, 1});
        }
    }

    @Test
    public void selectQuery_simpleExists() {
        long count = ObjectSelect.query(Artist.class).where(ExpressionFactory.exists(ObjectSelect.query(Painting.class, Painting.PAINTING_TITLE.like("painting%")))).selectCount(this.context);
        Assert.assertEquals((long)20L, (long)count);
    }

    @Test
    public void selectQuery_existsWithExpressionFromParentQuery() {
        Expression exp = Painting.TO_ARTIST.eq(Artist.ARTIST_ID_PK_PROPERTY.enclosing()).andExp(Painting.PAINTING_TITLE.like("painting%")).andExp(((StringProperty)Artist.ARTIST_NAME.enclosing()).like("art%"));
        ColumnSelect subQuery = ObjectSelect.columnQuery(Painting.class, Painting.PAINTING_TITLE).where(exp);
        long count = ObjectSelect.query(Artist.class).where(ExpressionFactory.exists(subQuery)).selectCount(this.context);
        Assert.assertEquals((long)5L, (long)count);
    }

    @Test
    public void selectQuery_notExistsWithExpressionFromParentQuery() {
        ObjectSelect<Painting> subQuery = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.eq(Artist.ARTIST_ID_PK_PROPERTY.enclosing()));
        long count = ObjectSelect.query(Artist.class).where(ExpressionFactory.notExists(subQuery)).selectCount(this.context);
        Assert.assertEquals((long)15L, (long)count);
    }

    @Test
    public void selectQuery_twoLevelExists() {
        Expression exp = Painting.PAINTING_TITLE.like("painting%").andExp(ExpressionFactory.exists(ObjectSelect.query(Gallery.class)));
        long count = ObjectSelect.query(Artist.class).where(ExpressionFactory.exists(ObjectSelect.query(Painting.class, exp))).selectCount(this.context);
        Assert.assertEquals((long)20L, (long)count);
    }

    @Test
    public void selectQuery_twoLevelExistsWithExpressionFromParentQuery() {
        Expression deepNestedExp = ((StringProperty)((StringProperty)Artist.ARTIST_NAME.enclosing()).enclosing()).like("art%").andExp(Painting.TO_GALLERY.enclosing().eq((BaseProperty<?>)PropertyFactory.createSelf(Gallery.class)));
        Expression exp = Painting.PAINTING_TITLE.like("painting%").andExp(ExpressionFactory.exists(ObjectSelect.query(Gallery.class, deepNestedExp))).andExp(Painting.TO_ARTIST.eq(PropertyFactory.createSelf(Artist.class).enclosing()));
        long count = ObjectSelect.query(Artist.class).where(ExpressionFactory.exists(ObjectSelect.query(Painting.class, exp))).selectCount(this.context);
        Assert.assertEquals((long)5L, (long)count);
    }

    @Test
    public void objectSelect_twoLevelExistsWithExpressionFromParentQuery() {
        ObjectSelect<Gallery> deepSubquery = ObjectSelect.query(Gallery.class).where(((StringProperty)((StringProperty)Artist.ARTIST_NAME.enclosing()).enclosing()).like("art%")).and(Painting.TO_GALLERY.enclosing().eq((BaseProperty<?>)PropertyFactory.createSelf(Gallery.class)));
        ObjectSelect<Painting> subquery = ObjectSelect.query(Painting.class).where(Painting.PAINTING_TITLE.like("painting%")).and(Painting.TO_ARTIST.eq(PropertyFactory.createSelf(Artist.class).enclosing())).and(ExpressionFactory.exists(deepSubquery));
        long count = ObjectSelect.query(Artist.class).where(ExpressionFactory.exists(subquery)).selectCount(this.context);
        Assert.assertEquals((long)5L, (long)count);
    }

    @Test
    public void columnSelect_simpleInSubquery() {
        ColumnSelect subquery = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).where(Artist.DATE_OF_BIRTH.lt(new java.util.Date()));
        long count = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).in(subquery)).selectCount(this.context);
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void columnSelect_simpleNotInSubquery() {
        ColumnSelect subquery = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).where(Artist.DATE_OF_BIRTH.lt(new java.util.Date()));
        long count = ObjectSelect.query(Painting.class).where(Painting.TO_ARTIST.dot(Artist.ARTIST_NAME).nin(subquery)).selectCount(this.context);
        Assert.assertEquals((long)16L, (long)count);
    }
}

