/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptorLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryDescriptorLoaderTest {
    protected QueryDescriptorLoader builder;

    @Before
    public void setUp() throws Exception {
        this.builder = new QueryDescriptorLoader();
    }

    @Test
    public void testSetName() throws Exception {
        this.builder.setName("aaa");
        Assert.assertEquals((Object)"aaa", (Object)this.builder.name);
    }

    @Test
    public void testSetRootInfoDbEntity() throws Exception {
        DataMap map = new DataMap("map");
        DbEntity entity = new DbEntity("DB1");
        map.addDbEntity(entity);
        this.builder.setRoot(map, "db-entity", "DB1");
        Assert.assertSame((Object)entity, (Object)this.builder.getRoot());
    }

    @Test
    public void testSetRootObjEntity() throws Exception {
        DataMap map = new DataMap("map");
        ObjEntity entity = new ObjEntity("OBJ1");
        map.addObjEntity(entity);
        this.builder.setRoot(map, "obj-entity", "OBJ1");
        Assert.assertSame((Object)entity, (Object)this.builder.getRoot());
    }

    @Test
    public void testSetRootDataMap() throws Exception {
        DataMap map = new DataMap("map");
        this.builder.setRoot(map, "data-map", null);
        Assert.assertSame((Object)map, (Object)this.builder.getRoot());
    }
}

