/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.EmptyConfigurationNodeVisitor;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.testdo.inheritance_vertical.Iv2Sub1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjRelationshipIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    private DbEntity artistDBEntity;
    private DbEntity artistExhibitDBEntity;
    private DbEntity exhibitDBEntity;
    private DbEntity paintingDbEntity;
    private DbEntity galleryDBEntity;

    @Before
    public void setUp() throws Exception {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        this.artistDBEntity = resolver.getDbEntity("ARTIST");
        this.artistExhibitDBEntity = resolver.getDbEntity("ARTIST_EXHIBIT");
        this.exhibitDBEntity = resolver.getDbEntity("EXHIBIT");
        this.paintingDbEntity = resolver.getDbEntity("PAINTING");
        this.galleryDBEntity = resolver.getDbEntity("GALLERY");
    }

    @Test
    public void testEncodeAsXML() {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        XMLEncoder encoder = new XMLEncoder(out);
        DataMap map = new DataMap("M");
        ObjEntity source = new ObjEntity("S");
        ObjEntity target = new ObjEntity("T");
        map.addObjEntity(source);
        map.addObjEntity(target);
        ObjRelationship r = new ObjRelationship("X");
        r.setSourceEntity(source);
        r.setTargetEntityName("T");
        r.setCollectionType("java.util.Map");
        r.setMapKey("bla");
        r.encodeAsXML(encoder, new EmptyConfigurationNodeVisitor());
        out.close();
        String lineBreak = System.getProperty("line.separator");
        Assert.assertEquals((Object)("<obj-relationship name=\"X\" source=\"S\" target=\"T\" collection-type=\"java.util.Map\" map-key=\"bla\"/>" + lineBreak), (Object)buffer.getBuffer().toString());
    }

    @Test
    public void testCollectionType() {
        ObjRelationship r = new ObjRelationship("X");
        Assert.assertNull((Object)r.getCollectionType());
        r.setCollectionType("java.util.Map");
        Assert.assertEquals((Object)"java.util.Map", (Object)r.getCollectionType());
    }

    @Test
    public void testSerializability() throws Exception {
        ObjEntity artistObjEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjRelationship r1 = artistObjEnt.getRelationship("paintingArray");
        ObjRelationship r2 = Util.cloneViaSerialization(r1);
        Assert.assertEquals((Object)r1.getName(), (Object)r2.getName());
        Assert.assertEquals((Object)r1.getDbRelationshipPath(), (Object)r2.getDbRelationshipPath());
    }

    @Test
    public void testGetClientRelationship() {
        final ObjEntity target = new ObjEntity("te1");
        ObjRelationship r1 = new ObjRelationship("r1"){

            @Override
            public ObjEntity getTargetEntity() {
                return target;
            }
        };
        r1.setDeleteRule(3);
        r1.setTargetEntityName("te1");
        ObjRelationship r2 = r1.getClientRelationship();
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((Object)r1.getName(), (Object)r2.getName());
        Assert.assertEquals((Object)r1.getTargetEntityName(), (Object)r2.getTargetEntityName());
        Assert.assertEquals((long)r1.getDeleteRule(), (long)r2.getDeleteRule());
    }

    @Test
    public void testGetReverseDbRelationshipPath() {
        ObjEntity artistObjEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjEntity paintingObjEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Painting");
        ObjRelationship r1 = artistObjEnt.getRelationship("paintingArray");
        Assert.assertEquals((Object)"toArtist", (Object)r1.getReverseDbRelationshipPath());
        ObjRelationship r2 = paintingObjEnt.getRelationship("toArtist");
        Assert.assertEquals((Object)"paintingArray", (Object)r2.getReverseDbRelationshipPath());
    }

    @Test
    public void testSetDbRelationshipPath() {
        ObjEntity artistObjEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjRelationship r = new ObjRelationship("r");
        r.setSourceEntity(artistObjEnt);
        r.setDbRelationshipPath("paintingArray");
        Assert.assertEquals((Object)r.getDbRelationshipPath(), (Object)"paintingArray");
    }

    @Test
    public void testRefreshFromPath() {
        ObjRelationship relationship = new ObjRelationship();
        try {
            relationship.setDbRelationshipPath("dummy.path");
            Assert.fail((String)"set random path should have failed.");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("Test");
        map.addObjEntity(entity);
        relationship.setSourceEntity(entity);
        try {
            relationship.refreshFromPath("dummy.path", false);
            Assert.fail((String)"refresh over a dummy path should have failed.");
        }
        catch (ExpressionException expressionException) {
            // empty catch block
        }
        DbEntity dbEntity1 = new DbEntity("TEST1");
        DbEntity dbEntity2 = new DbEntity("TEST2");
        DbEntity dbEntity3 = new DbEntity("TEST3");
        map.addDbEntity(dbEntity1);
        map.addDbEntity(dbEntity2);
        map.addDbEntity(dbEntity3);
        entity.setDbEntityName("TEST1");
        DbRelationship dummyR = new DbRelationship("dummy");
        dummyR.setTargetEntityName("TEST2");
        dummyR.setSourceEntity(dbEntity1);
        DbRelationship pathR = new DbRelationship("path");
        pathR.setTargetEntityName("TEST3");
        pathR.setSourceEntity(dbEntity2);
        dbEntity1.addRelationship(dummyR);
        dbEntity2.addRelationship(pathR);
        relationship.refreshFromPath("dummy.path", false);
        List<DbRelationship> resolvedPath = relationship.getDbRelationships();
        Assert.assertEquals((long)2L, (long)resolvedPath.size());
        Assert.assertSame((Object)dummyR, (Object)resolvedPath.get(0));
        Assert.assertSame((Object)pathR, (Object)resolvedPath.get(1));
    }

    @Test
    public void testCalculateToMany() {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("Test");
        map.addObjEntity(entity);
        DbEntity dbEntity1 = new DbEntity("TEST1");
        DbEntity dbEntity2 = new DbEntity("TEST2");
        DbEntity dbEntity3 = new DbEntity("TEST3");
        map.addDbEntity(dbEntity1);
        map.addDbEntity(dbEntity2);
        map.addDbEntity(dbEntity3);
        entity.setDbEntityName("TEST1");
        DbRelationship dummyR = new DbRelationship("dummy");
        dummyR.setTargetEntityName("TEST2");
        dummyR.setSourceEntity(dbEntity1);
        DbRelationship pathR = new DbRelationship("path");
        pathR.setTargetEntityName("TEST3");
        pathR.setSourceEntity(dbEntity2);
        dbEntity1.addRelationship(dummyR);
        dbEntity2.addRelationship(pathR);
        ObjRelationship relationship = new ObjRelationship();
        relationship.setSourceEntity(entity);
        relationship.dbRelationships.add(dummyR);
        Assert.assertFalse((boolean)relationship.isToMany());
        dummyR.setToMany(true);
        relationship.recalculateToManyValue();
        Assert.assertTrue((boolean)relationship.isToMany());
        dummyR.setToMany(false);
        relationship.recalculateToManyValue();
        Assert.assertFalse((boolean)relationship.isToMany());
        relationship.dbRelationships.add(pathR);
        Assert.assertFalse((boolean)relationship.isToMany());
        pathR.setToMany(true);
        relationship.recalculateToManyValue();
        Assert.assertTrue((boolean)relationship.isToMany());
    }

    @Test
    public void testCalculateToManyFromPath() {
        DataMap map = new DataMap();
        ObjEntity entity = new ObjEntity("Test");
        map.addObjEntity(entity);
        DbEntity dbEntity1 = new DbEntity("TEST1");
        DbEntity dbEntity2 = new DbEntity("TEST2");
        DbEntity dbEntity3 = new DbEntity("TEST3");
        map.addDbEntity(dbEntity1);
        map.addDbEntity(dbEntity2);
        map.addDbEntity(dbEntity3);
        entity.setDbEntityName("TEST1");
        DbRelationship dummyR = new DbRelationship("dummy");
        dummyR.setTargetEntityName("TEST2");
        dummyR.setSourceEntity(dbEntity1);
        DbRelationship pathR = new DbRelationship("path");
        pathR.setTargetEntityName("TEST3");
        pathR.setSourceEntity(dbEntity2);
        dbEntity1.addRelationship(dummyR);
        dbEntity2.addRelationship(pathR);
        ObjRelationship relationship = new ObjRelationship();
        relationship.setSourceEntity(entity);
        relationship.setDbRelationshipPath("dummy");
        Assert.assertFalse((boolean)relationship.isToMany());
        dummyR.setToMany(true);
        relationship.setDbRelationshipPath(null);
        relationship.setDbRelationshipPath("dummy");
        Assert.assertTrue((boolean)relationship.isToMany());
        dummyR.setToMany(false);
        relationship.setDbRelationshipPath(null);
        relationship.setDbRelationshipPath("dummy");
        Assert.assertFalse((boolean)relationship.isToMany());
        relationship.setDbRelationshipPath(null);
        relationship.setDbRelationshipPath("dummy.path");
        Assert.assertFalse((boolean)relationship.isToMany());
        pathR.setToMany(true);
        relationship.setDbRelationshipPath(null);
        relationship.setDbRelationshipPath("dummy.path");
        Assert.assertTrue((boolean)relationship.isToMany());
    }

    @Test
    public void testTargetEntity() throws Exception {
        ObjRelationship relationship = new ObjRelationship("some_rel");
        relationship.setTargetEntityName("targ");
        try {
            relationship.getTargetEntity();
            Assert.fail((String)"Without a container, getTargetEntity() must fail.");
        }
        catch (CayenneRuntimeException cayenneRuntimeException) {
            // empty catch block
        }
        DataMap map = new DataMap();
        ObjEntity src = new ObjEntity("src");
        map.addObjEntity(src);
        src.addRelationship(relationship);
        Assert.assertNull((Object)relationship.getTargetEntity());
        ObjEntity target = new ObjEntity("targ");
        map.addObjEntity(target);
        Assert.assertSame((Object)target, (Object)relationship.getTargetEntity());
    }

    @Test
    public void testGetReverseRel1() {
        ObjEntity artistObjEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjEntity paintingObjEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Painting");
        ObjRelationship r1 = artistObjEnt.getRelationship("paintingArray");
        ObjRelationship r2 = r1.getReverseRelationship();
        Assert.assertNotNull((Object)r2);
        Assert.assertSame((Object)paintingObjEnt.getRelationship("toArtist"), (Object)r2);
    }

    @Test
    public void testGetReverseRel2() {
        ObjEntity artistEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjEntity paintingEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Painting");
        ObjRelationship r1 = paintingEnt.getRelationship("toArtist");
        ObjRelationship r2 = r1.getReverseRelationship();
        Assert.assertNotNull((Object)r2);
        Assert.assertSame((Object)artistEnt.getRelationship("paintingArray"), (Object)r2);
    }

    @Test
    public void testSingleDbRelationship() {
        ObjRelationship relationship = new ObjRelationship();
        DbRelationship r1 = new DbRelationship("X");
        relationship.addDbRelationship(r1);
        Assert.assertEquals((long)1L, (long)relationship.getDbRelationships().size());
        Assert.assertEquals((Object)r1, (Object)relationship.getDbRelationships().get(0));
        Assert.assertFalse((boolean)relationship.isFlattened());
        Assert.assertFalse((boolean)relationship.isReadOnly());
        Assert.assertEquals((Object)r1.isToMany(), (Object)relationship.isToMany());
        relationship.removeDbRelationship(r1);
        Assert.assertEquals((long)0L, (long)relationship.getDbRelationships().size());
    }

    @Test
    public void testFlattenedRelationship() {
        DbRelationship r1 = new DbRelationship("X");
        DbRelationship r2 = new DbRelationship("Y");
        r1.setSourceEntity(this.artistDBEntity);
        r1.setTargetEntityName(this.artistExhibitDBEntity);
        r1.setToMany(true);
        r2.setSourceEntity(this.artistExhibitDBEntity);
        r2.setTargetEntityName(this.exhibitDBEntity);
        r2.setToMany(false);
        ObjRelationship relationship = new ObjRelationship();
        relationship.addDbRelationship(r1);
        relationship.addDbRelationship(r2);
        Assert.assertTrue((boolean)relationship.isToMany());
        Assert.assertEquals((long)2L, (long)relationship.getDbRelationships().size());
        Assert.assertEquals((Object)r1, (Object)relationship.getDbRelationships().get(0));
        Assert.assertEquals((Object)r2, (Object)relationship.getDbRelationships().get(1));
        Assert.assertTrue((boolean)relationship.isFlattened());
        relationship.removeDbRelationship(r1);
        Assert.assertFalse((boolean)relationship.isToMany());
        Assert.assertEquals((long)1L, (long)relationship.getDbRelationships().size());
        Assert.assertEquals((Object)r2, (Object)relationship.getDbRelationships().get(0));
        Assert.assertFalse((boolean)relationship.isFlattened());
        Assert.assertFalse((boolean)relationship.isReadOnly());
    }

    @Test
    public void testReadOnly_Flattened1_1__N_1() {
        DataMapLoader loader = (DataMapLoader)this.runtime.getInjector().getInstance(DataMapLoader.class);
        URL url = this.getClass().getClassLoader().getResource("inheritance-vertical.map.xml");
        DataMap dataMap = loader.load(new URLResource(url));
        EntityResolver resolver = new EntityResolver(Collections.singleton(dataMap));
        ObjEntity iv2Sub1 = resolver.getObjEntity(Iv2Sub1.class);
        ObjRelationship x = iv2Sub1.getRelationship(Iv2Sub1.X.getName());
        Assert.assertTrue((boolean)x.isFlattened());
        Assert.assertFalse((boolean)x.isReadOnly());
    }

    @Test
    public void testReadOnlyMoreThan3DbRelsRelationship() {
        DbRelationship r1 = new DbRelationship("X");
        DbRelationship r2 = new DbRelationship("Y");
        DbRelationship r3 = new DbRelationship("Z");
        r1.setSourceEntity(this.artistDBEntity);
        r1.setTargetEntityName(this.artistExhibitDBEntity);
        r1.setToMany(true);
        r2.setSourceEntity(this.artistExhibitDBEntity);
        r2.setTargetEntityName(this.exhibitDBEntity);
        r2.setToMany(false);
        r3.setSourceEntity(this.exhibitDBEntity);
        r3.setTargetEntityName(this.galleryDBEntity);
        r3.setToMany(false);
        ObjRelationship relationship = new ObjRelationship();
        relationship.addDbRelationship(r1);
        relationship.addDbRelationship(r2);
        relationship.addDbRelationship(r3);
        Assert.assertTrue((boolean)relationship.isFlattened());
        Assert.assertTrue((boolean)relationship.isToMany());
    }

    @Test
    public void testIncorrectSequenceReadOnlyRelationship() {
        DbRelationship r1 = new DbRelationship("X");
        DbRelationship r2 = new DbRelationship("Y");
        r1.setSourceEntity(this.artistDBEntity);
        r1.setTargetEntityName(this.paintingDbEntity);
        r1.setToMany(true);
        r2.setSourceEntity(this.paintingDbEntity);
        r2.setTargetEntityName(this.galleryDBEntity);
        r2.setToMany(false);
        ObjRelationship relationship = new ObjRelationship();
        relationship.addDbRelationship(r1);
        relationship.addDbRelationship(r2);
        Assert.assertTrue((boolean)relationship.isFlattened());
        Assert.assertTrue((boolean)relationship.isToMany());
    }

    @Test
    public void testKnownFlattenedRelationship() {
        ObjEntity artistEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Artist");
        ObjRelationship theRel = artistEnt.getRelationship("groupArray");
        Assert.assertNotNull((Object)theRel);
        Assert.assertTrue((boolean)theRel.isFlattened());
        Assert.assertFalse((boolean)theRel.isReadOnly());
    }

    @Test
    public void testBadDeleteRuleValue() {
        ObjRelationship relationship = new ObjRelationship();
        try {
            relationship.setDeleteRule(999);
            Assert.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOkDeleteRuleValue() {
        ObjRelationship relationship = new ObjRelationship();
        try {
            relationship.setDeleteRule(2);
            relationship.setDeleteRule(3);
            relationship.setDeleteRule(1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Assert.fail((String)("Should not have thrown an exception :" + e.getMessage()));
        }
    }
}

