/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringPropertyTest {
    private StringProperty<String> property;
    private StringProperty<String> other;

    @Before
    public void createProperty() {
        this.property = new StringProperty<String>("path", null, String.class);
        this.other = new StringProperty<String>("other", null, String.class);
    }

    @Test
    public void like() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path like 'abc'", new Object[0]), (Object)this.property.like("abc"));
    }

    @Test
    public void likeProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path like other", new Object[0]), (Object)this.property.like(this.other));
    }

    @Test
    public void likeWithEscape() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path like 'abc'", new Object[0]), (Object)this.property.like("abc", '|'));
    }

    @Test
    public void likeIgnoreCase() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path likeIgnoreCase 'abc'", new Object[0]), (Object)this.property.likeIgnoreCase("abc"));
    }

    @Test
    public void likeIgnoreCaseProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path likeIgnoreCase other", new Object[0]), (Object)this.property.likeIgnoreCase(this.other));
    }

    @Test
    public void nlike() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path not like 'abc'", new Object[0]), (Object)this.property.nlike("abc"));
    }

    @Test
    public void nlikeProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path not like other", new Object[0]), (Object)this.property.nlike(this.other));
    }

    @Test
    public void nlikeIgnoreCase() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path not likeIgnoreCase 'abc'", new Object[0]), (Object)this.property.nlikeIgnoreCase("abc"));
    }

    @Test
    public void nlikeIgnoreCaseProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path not likeIgnoreCase other", new Object[0]), (Object)this.property.nlikeIgnoreCase(this.other));
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path like '%abc%'", new Object[0]), (Object)this.property.contains("abc"));
    }

    @Test
    public void startsWith() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path like 'abc%'", new Object[0]), (Object)this.property.startsWith("abc"));
    }

    @Test
    public void endsWith() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path like '%abc'", new Object[0]), (Object)this.property.endsWith("abc"));
    }

    @Test
    public void containsIgnoreCase() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path likeIgnoreCase '%abc%'", new Object[0]), (Object)this.property.containsIgnoreCase("abc"));
    }

    @Test
    public void startsWithIgnoreCase() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path likeIgnoreCase 'abc%'", new Object[0]), (Object)this.property.startsWithIgnoreCase("abc"));
    }

    @Test
    public void endsWithIgnoreCase() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path likeIgnoreCase '%abc'", new Object[0]), (Object)this.property.endsWithIgnoreCase("abc"));
    }

    @Test
    public void length() {
        Assert.assertEquals((Object)ExpressionFactory.exp("length(path)", new Object[0]), (Object)this.property.length().getExpression());
    }

    @Test
    public void locate() {
        Assert.assertEquals((Object)ExpressionFactory.exp("locate('abc', path)", new Object[0]), (Object)this.property.locate("abc").getExpression());
    }

    @Test
    public void locateProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("locate(other, path)", new Object[0]), (Object)this.property.locate(this.other).getExpression());
    }

    @Test
    public void trim() {
        Assert.assertEquals((Object)ExpressionFactory.exp("trim(path)", new Object[0]), (Object)this.property.trim().getExpression());
    }

    @Test
    public void upper() {
        Assert.assertEquals((Object)ExpressionFactory.exp("upper(path)", new Object[0]), (Object)this.property.upper().getExpression());
    }

    @Test
    public void lower() {
        Assert.assertEquals((Object)ExpressionFactory.exp("lower(path)", new Object[0]), (Object)this.property.lower().getExpression());
    }

    @Test
    public void concat() {
        Assert.assertEquals((Object)ExpressionFactory.exp("concat(path, 'abc', ' ', 'def', other)", new Object[0]), (Object)this.property.concat("abc", Character.valueOf(' '), ExpressionFactory.exp("'def'", new Object[0]), this.other).getExpression());
    }

    @Test
    public void substring() {
        Assert.assertEquals((Object)ExpressionFactory.exp("substring(path, 10, 30)", new Object[0]), (Object)this.property.substring(10, 30).getExpression());
    }

    @Test
    public void substringProp() {
        NumericProperty<Integer> offset = PropertyFactory.createNumeric("offset", Integer.class);
        NumericProperty<Integer> length = PropertyFactory.createNumeric("len", Integer.class);
        Assert.assertEquals((Object)ExpressionFactory.exp("substring(path, offset, len)", new Object[0]), (Object)this.property.substring(offset, length).getExpression());
    }

    @Test
    public void compare() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path > 'abc'", new Object[0]), (Object)this.property.gt("abc"));
        Assert.assertEquals((Object)ExpressionFactory.exp("path > other", new Object[0]), (Object)this.property.gt(this.other));
        Assert.assertEquals((Object)ExpressionFactory.exp("path >= 'abc'", new Object[0]), (Object)this.property.gte("abc"));
        Assert.assertEquals((Object)ExpressionFactory.exp("path >= other", new Object[0]), (Object)this.property.gte(this.other));
        Assert.assertEquals((Object)ExpressionFactory.exp("path < 'abc'", new Object[0]), (Object)this.property.lt("abc"));
        Assert.assertEquals((Object)ExpressionFactory.exp("path < other", new Object[0]), (Object)this.property.lt(this.other));
        Assert.assertEquals((Object)ExpressionFactory.exp("path <= 'abc'", new Object[0]), (Object)this.property.lte("abc"));
        Assert.assertEquals((Object)ExpressionFactory.exp("path <= other", new Object[0]), (Object)this.property.lte(this.other));
    }

    @Test
    public void alias() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        Assert.assertNull((Object)this.property.getAlias());
        this.property = this.property.alias("alias");
        Assert.assertEquals((Object)"alias", (Object)this.property.getName());
        Assert.assertEquals((Object)"alias", (Object)this.property.getAlias());
    }
}

