/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Arrays;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.NumericProperty;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumericPropertyTest {
    private NumericProperty<Integer> property;
    private NumericProperty<Integer> other;

    @Before
    public void createProperty() {
        this.property = new NumericProperty<Integer>("path", null, Integer.class);
        this.other = new NumericProperty<Integer>("other", null, Integer.class);
    }

    @Test
    public void avg() {
        Assert.assertEquals((Object)ExpressionFactory.exp("avg(path)", new Object[0]), (Object)this.property.avg().getExpression());
    }

    @Test
    public void min() {
        Assert.assertEquals((Object)ExpressionFactory.exp("min(path)", new Object[0]), (Object)this.property.min().getExpression());
    }

    @Test
    public void max() {
        Assert.assertEquals((Object)ExpressionFactory.exp("max(path)", new Object[0]), (Object)this.property.max().getExpression());
    }

    @Test
    public void sum() {
        Assert.assertEquals((Object)ExpressionFactory.exp("sum(path)", new Object[0]), (Object)this.property.sum().getExpression());
    }

    @Test
    public void count() {
        Assert.assertEquals((Object)ExpressionFactory.exp("count(path)", new Object[0]), (Object)this.property.count().getExpression());
    }

    @Test
    public void modNumber() {
        Assert.assertEquals((Object)ExpressionFactory.exp("mod(path, 3)", new Object[0]), (Object)this.property.mod(3).getExpression());
    }

    @Test
    public void modProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("mod(path, other)", new Object[0]), (Object)this.property.mod(this.other).getExpression());
    }

    @Test
    public void abs() {
        Assert.assertEquals((Object)ExpressionFactory.exp("abs(path)", new Object[0]), (Object)this.property.abs().getExpression());
    }

    @Test
    public void sqrt() {
        Assert.assertEquals((Object)ExpressionFactory.exp("sqrt(path)", new Object[0]), (Object)this.property.sqrt().getExpression());
    }

    @Test
    public void add() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path + 42", new Object[0]), (Object)this.property.add(42).getExpression());
    }

    @Test
    public void addProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path + other", new Object[0]), (Object)this.property.add(this.other).getExpression());
    }

    @Test
    public void sub() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path - 42", new Object[0]), (Object)this.property.sub(42).getExpression());
    }

    @Test
    public void subProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path - other", new Object[0]), (Object)this.property.sub(this.other).getExpression());
    }

    @Test
    public void div() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path / 42", new Object[0]), (Object)this.property.div(42).getExpression());
    }

    @Test
    public void divProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path / other", new Object[0]), (Object)this.property.div(this.other).getExpression());
    }

    @Test
    public void mul() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path * 42", new Object[0]), (Object)this.property.mul(42).getExpression());
    }

    @Test
    public void mulProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path * other", new Object[0]), (Object)this.property.mul(this.other).getExpression());
    }

    @Test
    public void neg() {
        Assert.assertEquals((Object)ExpressionFactory.exp("- path", new Object[0]), (Object)this.property.neg().getExpression());
    }

    @Test
    public void between() {
        Expression exp1 = ExpressionFactory.exp("path between 42 and 123", new Object[0]);
        Expression exp2 = this.property.between(42, 123);
        Assert.assertEquals((Object)exp1, (Object)exp2);
    }

    @Test
    public void betweenProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path between -other and other", new Object[0]), (Object)this.property.between(this.other.neg(), this.other));
    }

    @Test
    public void eq() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path = 123", new Object[0]), (Object)this.property.eq(123));
    }

    @Test
    public void eqProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path = other", new Object[0]), (Object)this.property.eq(this.other));
    }

    @Test
    public void ne() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path != 123", new Object[0]), (Object)this.property.ne(123));
    }

    @Test
    public void neProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path != other", new Object[0]), (Object)this.property.ne(this.other));
    }

    @Test
    public void inArray() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1, 2, 3)", new Object[0]), (Object)this.property.in(1, (Integer[])new Integer[]{2, 3}));
    }

    @Test
    public void inCollection() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1, 2, 3)", new Object[0]), (Object)this.property.in(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void ninArray() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1, 2, 3)", new Object[0]), (Object)this.property.nin(1, (Integer[])new Integer[]{2, 3}));
    }

    @Test
    public void ninCollection() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1, 2, 3)", new Object[0]), (Object)this.property.nin(Arrays.asList(1, 2, 3)));
    }

    @Test
    public void gt() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path > 123", new Object[0]), (Object)this.property.gt(123));
    }

    @Test
    public void gtProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path > other", new Object[0]), (Object)this.property.gt(this.other));
    }

    @Test
    public void gte() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path >= 123", new Object[0]), (Object)this.property.gte(123));
    }

    @Test
    public void gteProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path >= other", new Object[0]), (Object)this.property.gte(this.other));
    }

    @Test
    public void lt() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path < 42", new Object[0]), (Object)this.property.lt(42));
    }

    @Test
    public void ltProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path < other", new Object[0]), (Object)this.property.lt(this.other));
    }

    @Test
    public void lte() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path <= 42", new Object[0]), (Object)this.property.lte(42));
    }

    @Test
    public void lteProp() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path <= other", new Object[0]), (Object)this.property.lte(this.other));
    }

    @Test
    public void isTrue() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path = true", new Object[0]), (Object)this.property.isTrue());
    }

    @Test
    public void isFalse() {
        Assert.assertEquals((Object)ExpressionFactory.exp("path = false", new Object[0]), (Object)this.property.isFalse());
    }

    @Test
    public void alias() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        Assert.assertNull((Object)this.property.getAlias());
        this.property = this.property.alias("alias");
        Assert.assertEquals((Object)"alias", (Object)this.property.getName());
        Assert.assertEquals((Object)"alias", (Object)this.property.getAlias());
    }
}

