/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Arrays;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.MapProperty;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapPropertyTest {
    private MapProperty<Integer, Artist> property;
    private MapProperty<Integer, Artist> property1;

    @Before
    public void createProperty() {
        this.property = new MapProperty<Integer, Artist>("path", null, Integer.class, Artist.class);
        this.property1 = new MapProperty<Integer, Artist>("path.artist", null, Integer.class, Artist.class);
    }

    @Test
    public void flat() {
        Expression exp = this.property.flat().getExpression();
        Assert.assertEquals((Object)ExpressionFactory.fullObjectExp(ExpressionFactory.pathExp("path")), (Object)exp);
    }

    @Test
    public void containsOne() {
        Artist artist = new Artist();
        Expression exp = this.property.contains(artist);
        Assert.assertEquals((Object)ExpressionFactory.matchExp("path", (Object)artist), (Object)exp);
    }

    @Test
    public void notContainsOne() {
        Artist artist = new Artist();
        Expression exp = this.property.notContains(artist);
        Assert.assertEquals((Object)ExpressionFactory.noMatchExp("path", (Object)artist), (Object)exp);
    }

    @Test
    public void containsManyArray() {
        Artist artist1 = new Artist();
        Artist artist2 = new Artist();
        Expression exp = this.property.contains(artist1, new Artist[]{artist2});
        Assert.assertEquals((Object)ExpressionFactory.inExp("path", Arrays.asList(artist1, artist2)), (Object)exp);
    }

    @Test
    public void containsManyCollection() {
        Artist artist1 = new Artist();
        Artist artist2 = new Artist();
        Expression exp = this.property.contains(Arrays.asList(artist1, artist2));
        Assert.assertEquals((Object)ExpressionFactory.inExp("path", Arrays.asList(artist1, artist2)), (Object)exp);
    }

    @Test
    public void notContainsManyArray() {
        Artist artist1 = new Artist();
        Artist artist2 = new Artist();
        Expression exp = this.property.notContains(artist1, new Artist[]{artist2});
        Assert.assertEquals((Object)ExpressionFactory.notInExp("path", Arrays.asList(artist1, artist2)), (Object)exp);
    }

    @Test
    public void notContainsManyCollection() {
        Artist artist1 = new Artist();
        Artist artist2 = new Artist();
        Expression exp = this.property.notContains(Arrays.asList(artist1, artist2));
        Assert.assertEquals((Object)ExpressionFactory.notInExp("path", Arrays.asList(artist1, artist2)), (Object)exp);
    }

    @Test
    public void containsOneId() {
        Expression exp = this.property.containsId(1);
        Assert.assertEquals((Object)ExpressionFactory.exp("path = 1", new Object[0]), (Object)exp);
    }

    @Test
    public void containsManyIdArray() {
        Expression exp = this.property.containsId(1, 2, 3);
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1,2,3)", new Object[0]), (Object)exp);
    }

    @Test
    public void containsManyIdCollection() {
        Expression exp = this.property.containsId(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ExpressionFactory.exp("path in (1,2,3)", new Object[0]), (Object)exp);
    }

    @Test
    public void notContainsOneId() {
        Expression exp = this.property.notContainsId(1);
        Assert.assertEquals((Object)ExpressionFactory.exp("path != 1", new Object[0]), (Object)exp);
    }

    @Test
    public void notContainsManyIdArray() {
        Expression exp = this.property.notContainsId(1, 2, 3);
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1,2,3)", new Object[0]), (Object)exp);
    }

    @Test
    public void notContainsManyIdCollection() {
        Expression exp = this.property.notContainsId(Arrays.asList(1, 2, 3));
        Assert.assertEquals((Object)ExpressionFactory.exp("path not in (1,2,3)", new Object[0]), (Object)exp);
    }

    @Test
    public void alias() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        this.property = this.property.alias("alias");
        Assert.assertEquals((Object)"alias", (Object)this.property.getName());
        Assert.assertEquals((long)1L, (long)this.property.getExpression().getPathAliases().size());
        Assert.assertEquals((Object)"path.artist", (Object)this.property1.getName());
        this.property1 = this.property1.alias("a");
        Assert.assertEquals((Object)"path.a", (Object)this.property1.getName());
        Assert.assertEquals((long)1L, (long)this.property1.getExpression().getPathAliases().size());
        Assert.assertEquals((Object)"artist", (Object)this.property1.getExpression().getPathAliases().get("a"));
    }

    @Test
    public void outer() {
        Assert.assertEquals((Object)"path", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path"), (Object)this.property.getExpression());
        this.property = this.property.outer();
        Assert.assertEquals((Object)"path+", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path+"), (Object)this.property.getExpression());
        this.property = this.property.outer();
        Assert.assertEquals((Object)"path+", (Object)this.property.getName());
        Assert.assertEquals((Object)ExpressionFactory.pathExp("path+"), (Object)this.property.getExpression());
    }
}

