/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class AggregateExpInMemoryEvaluationIT
extends ServerCase {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3, Locale.US);
    @Inject
    private DBHelper dbHelper;
    @Inject
    private DataContext context;

    @Before
    public void createArtistsDataSet() throws Exception {
        int i;
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        tArtist.setColumnTypes(new int[]{4, 12, 91});
        Date[] dates = new Date[5];
        for (i = 1; i <= 5; ++i) {
            dates[i - 1] = new Date(DATE_FORMAT.parse("1/" + i + "/17").getTime());
        }
        for (i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, dates[i % 5]});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID", "ESTIMATED_PRICE"});
        for (int i2 = 1; i2 <= 20; ++i2) {
            tPaintings.insert(new Object[]{i2, "painting" + i2, i2 % 5 + 1, 1, i2 * 10});
        }
        tPaintings.insert(new Object[]{21, "painting21", 2, 1, 1000});
    }

    @After
    public void clearArtistsDataSet() throws Exception {
        for (String table : Arrays.asList("PAINTING", "ARTIST", "GALLERY")) {
            TableHelper tHelper = new TableHelper(this.dbHelper, table);
            tHelper.deleteAll();
        }
    }

    @Test
    public void testCount() {
        List artists = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_ID_PK_PROPERTY.asc()).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        Expression countExp = Artist.PAINTING_ARRAY.count().getExpression();
        for (Artist artist : artists) {
            Assert.assertEquals((Object)artist.getPaintingArray().size(), (Object)countExp.evaluate(artist));
        }
    }

    @Test
    public void testMax() {
        List artists = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_ID_PK_PROPERTY.asc()).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        Expression maxExp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).max().getExpression();
        Object max0 = maxExp.evaluate(artists.get(0));
        BigDecimal expected0 = BigDecimal.valueOf(20000L, 2);
        Assert.assertEquals((Object)expected0, (Object)max0);
        Object max1 = maxExp.evaluate(artists.get(1));
        BigDecimal expected1 = BigDecimal.valueOf(100000L, 2);
        Assert.assertEquals((Object)expected1, (Object)max1);
        Object max4 = maxExp.evaluate(artists.get(4));
        BigDecimal expected4 = BigDecimal.valueOf(19000L, 2);
        Assert.assertEquals((Object)expected4, (Object)max4);
    }

    @Test
    public void testMin() {
        List artists = ObjectSelect.query(Artist.class).orderBy(Artist.ARTIST_ID_PK_PROPERTY.asc()).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        Expression minExp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).min().getExpression();
        Object min0 = minExp.evaluate(artists.get(0));
        BigDecimal expected0 = BigDecimal.valueOf(5000L, 2);
        Assert.assertEquals((Object)expected0, (Object)min0);
        Object min3 = minExp.evaluate(artists.get(3));
        BigDecimal expected1 = BigDecimal.valueOf(3000L, 2);
        Assert.assertEquals((Object)expected1, (Object)min3);
        Object min4 = minExp.evaluate(artists.get(4));
        BigDecimal expected4 = BigDecimal.valueOf(4000L, 2);
        Assert.assertEquals((Object)expected4, (Object)min4);
    }

    @Test
    public void testAvg() {
        List artists = ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint()).orderBy(Artist.ARTIST_ID_PK_PROPERTY.asc()).select(this.context);
        Expression avgExp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).avg().getExpression();
        Object avg0 = avgExp.evaluate(artists.get(0));
        Assert.assertEquals((Object)125.0, (Object)avg0);
        Object avg2 = avgExp.evaluate(artists.get(2));
        Assert.assertEquals((Object)95.0, (Object)avg2);
    }
}

