/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class MySQLAdapterIT
extends ServerCase {
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testCreateTableAppendPKClause() {
        MySQLAdapter adapter = (MySQLAdapter)this.objectFactory.newInstance(MySQLAdapter.class, MySQLAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute pk1 = new DbAttribute("PK1");
        pk1.setPrimaryKey(true);
        e.addAttribute(pk1);
        DbAttribute pk2 = new DbAttribute("PK2");
        pk2.setPrimaryKey(true);
        e.addAttribute(pk2);
        StringBuffer b1 = new StringBuffer();
        adapter.createTableAppendPKClause(b1, e);
        Assert.assertTrue((b1.indexOf("PK1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b1.indexOf("PK2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b1.indexOf("PK1") < b1.indexOf("PK2") ? 1 : 0) != 0);
        pk2.setGenerated(true);
        StringBuffer b2 = new StringBuffer();
        adapter.createTableAppendPKClause(b2, e);
        Assert.assertTrue((b2.indexOf("PK1") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b2.indexOf("PK2") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((b2.indexOf("PK1") > b2.indexOf("PK2") ? 1 : 0) != 0);
    }

    @Test
    public void testCreateTableAppendColumnWithTimeAndTimestamp() {
        MySQLAdapter adapter = (MySQLAdapter)this.objectFactory.newInstance(MySQLAdapter.class, MySQLAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute dblPrec1 = new DbAttribute("dbl1");
        dblPrec1.setType(93);
        dblPrec1.setScale(3);
        e.addAttribute(dblPrec1);
        DbAttribute dblPrec2 = new DbAttribute("dbl2");
        dblPrec2.setType(92);
        dblPrec2.setScale(6);
        e.addAttribute(dblPrec2);
        String sql = adapter.createTable(e);
        Assert.assertTrue((sql.indexOf("TIME(6)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((sql.indexOf("DATETIME(3)") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"CREATE TABLE Test (dbl1 DATETIME(3) NULL, dbl2 TIME(6) NULL) ENGINE=InnoDB", (Object)sql);
    }

    @Test
    public void testCreateTableAppendColumnWithTimeAndTimestampWihoutScale() {
        MySQLAdapter adapter = (MySQLAdapter)this.objectFactory.newInstance(MySQLAdapter.class, MySQLAdapter.class.getName());
        DbEntity e = new DbEntity("Test");
        DbAttribute dblPrec1 = new DbAttribute("dbl1");
        dblPrec1.setType(93);
        e.addAttribute(dblPrec1);
        DbAttribute dblPrec2 = new DbAttribute("dbl2");
        dblPrec2.setType(92);
        e.addAttribute(dblPrec2);
        String sql = adapter.createTable(e);
        Assert.assertTrue((sql.indexOf("TIME") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((sql.indexOf("DATETIME") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"CREATE TABLE Test (dbl1 DATETIME NULL, dbl2 TIME NULL) ENGINE=InnoDB", (Object)sql);
    }
}

