/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.sqlbuilder.SQLGenerationVisitor;
import org.apache.cayenne.access.sqlbuilder.StringBuilderAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.DefaultSelectTranslator;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.compound.CompoundFkTestEntity;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class QualifierTranslatorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectContext context;
    @Inject
    protected DBHelper dbHelper;

    @Before
    public void setUp() throws Exception {
        TableHelper tCompoundPKTest = new TableHelper(this.dbHelper, "COMPOUND_PK_TEST");
        tCompoundPKTest.setColumns(new String[]{"KEY1", "KEY2", "NAME"});
        tCompoundPKTest.insert(new Object[]{"PK1", "PK2", "BBB"});
    }

    @Test
    public void testCompoundPK() {
        CompoundPkTestEntity testEntity = ObjectSelect.query(CompoundPkTestEntity.class).selectFirst(this.context);
        Assert.assertNotNull((Object)testEntity);
        ObjectSelect<CompoundFkTestEntity> query = ObjectSelect.query(CompoundFkTestEntity.class).where(CompoundFkTestEntity.TO_COMPOUND_PK.eq(testEntity)).and(CompoundFkTestEntity.NAME.like("test%")).and(CompoundFkTestEntity.NAME.contains("a"));
        DefaultSelectTranslator translator = new DefaultSelectTranslator(query, this.runtime.getDataDomain().getDefaultNode().getAdapter(), this.context.getEntityResolver());
        QualifierTranslator qualifierTranslator = translator.getContext().getQualifierTranslator();
        Node node = qualifierTranslator.translate(query.getWhere());
        SQLGenerationVisitor visitor = new SQLGenerationVisitor(new StringBuilderAppendable());
        node.visit(visitor);
        Assert.assertEquals((Object)" ( ( ( t0.F_KEY1 = 'PK1' ) AND ( t0.F_KEY2 = 'PK2' ) ) AND t0.NAME LIKE 'test%' ) AND t0.NAME LIKE '%a%'", (Object)visitor.getSQLString());
    }
}

