/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Collections;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.EmptyNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.OrderByNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.access.translator.select.MockQueryMetadataBuilder;
import org.apache.cayenne.access.translator.select.MockQueryWrapperBuilder;
import org.apache.cayenne.access.translator.select.MockTranslatorContext;
import org.apache.cayenne.access.translator.select.OrderingStage;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Ordering;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrderingStageTest {
    private TranslatorContext context;

    @Before
    public void prepareContext() {
        DbEntity dbEntity = new DbEntity();
        dbEntity.setName("mock");
        DbAttribute dbAttribute = new DbAttribute();
        dbAttribute.setName("path");
        dbEntity.addAttribute(dbAttribute);
        ObjEntity objEntity = new ObjEntity();
        objEntity.setName("mock");
        objEntity.setDbEntity(dbEntity);
        ObjAttribute objAttribute = new ObjAttribute();
        objAttribute.setName("path");
        objAttribute.setDbAttributePath("path");
        objEntity.addAttribute(objAttribute);
        DataMap dataMap = new DataMap();
        dataMap.addObjEntity(objEntity);
        dataMap.addDbEntity(dbEntity);
        Ordering ordering = new Ordering("path");
        ordering.setDescending();
        TranslatableQueryWrapper wrapper = new MockQueryWrapperBuilder().withOrderings(Collections.singleton(ordering)).withMetaData(new MockQueryMetadataBuilder().withDbEntity(dbEntity).withObjEntity(objEntity).build()).build();
        this.context = new MockTranslatorContext(wrapper);
    }

    @Test
    public void perform() {
        OrderingStage orderingStage = new OrderingStage();
        orderingStage.perform(this.context);
        Node select = this.context.getSelectBuilder().build();
        Node child = select.getChild(0);
        Assert.assertEquals((long)1L, (long)select.getChildrenCount());
        Assert.assertThat((Object)child, (Matcher)CoreMatchers.instanceOf(OrderByNode.class));
        Assert.assertEquals((long)1L, (long)child.getChildrenCount());
        Assert.assertThat((Object)child.getChild(0), (Matcher)CoreMatchers.instanceOf(EmptyNode.class));
        Assert.assertEquals((long)2L, (long)child.getChild(0).getChildrenCount());
        Assert.assertThat((Object)child.getChild(0).getChild(0), (Matcher)CoreMatchers.instanceOf(ColumnNode.class));
        Assert.assertThat((Object)child.getChild(0).getChild(1), (Matcher)CoreMatchers.instanceOf(TextNode.class));
        ColumnNode columnNode = (ColumnNode)child.getChild(0).getChild(0);
        Assert.assertEquals((Object)"path", (Object)columnNode.getColumn());
        Assert.assertEquals((Object)"Node { DESC}", (Object)child.getChild(0).getChild(1).toString());
    }
}

