/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.translator.select.FluentSelectWrapper;
import org.apache.cayenne.access.translator.select.ObjPathProcessor;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjPathProcessorIT4
extends ServerCase {
    @Inject
    protected ObjectContext context;
    private ObjPathProcessor pathProcessor;

    @Before
    public void prepareTranslationContext() {
        TranslatorContext translatorContext = new TranslatorContext(new FluentSelectWrapper(ObjectSelect.query(Object.class)), (DbAdapter)Mockito.mock(DbAdapter.class), this.context.getEntityResolver(), null);
        ObjEntity entity = this.context.getEntityResolver().getObjEntity("CompoundPainting");
        this.pathProcessor = new ObjPathProcessor(translatorContext, entity, null);
    }

    @Test
    public void testSimpleAttributePathTranslation() {
        PathTranslationResult result = this.pathProcessor.process("textReview");
        Assert.assertEquals((long)2L, (long)result.getDbAttributes().size());
        Assert.assertEquals((long)2L, (long)result.getAttributePaths().size());
        Assert.assertEquals((Object)"toPaintingInfo", (Object)result.getAttributePaths().get(0));
        Assert.assertEquals((Object)"PAINTING_ID", (Object)result.getDbAttributes().get(0).getName());
        Assert.assertEquals((Object)"toPaintingInfo", (Object)result.getAttributePaths().get(1));
        Assert.assertEquals((Object)"TEXT_REVIEW", (Object)result.getDbAttributes().get(1).getName());
    }
}

