/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Collection;
import org.apache.cayenne.access.translator.select.TranslatableQueryWrapper;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.MockQueryMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.Select;

class MockQueryWrapperBuilder {
    private boolean distinct;
    private QueryMetadata metaData;
    private PrefetchTreeNode prefetchTreeNode;
    private Expression qualifier;
    private Collection<Ordering> orderings;
    private Collection<Property<?>> columns;
    private Expression havingQualifier;
    private Select<?> mockSelect;
    private boolean needsResultSetMapping;

    MockQueryWrapperBuilder() {
    }

    MockQueryWrapperBuilder withDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    MockQueryWrapperBuilder withMetaData(QueryMetadata metaData) {
        this.metaData = metaData;
        return this;
    }

    MockQueryWrapperBuilder withPrefetchTreeNode(PrefetchTreeNode prefetchTreeNode) {
        this.prefetchTreeNode = prefetchTreeNode;
        return this;
    }

    MockQueryWrapperBuilder withQualifier(Expression qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    MockQueryWrapperBuilder withOrderings(Collection<Ordering> orderings) {
        this.orderings = orderings;
        return this;
    }

    MockQueryWrapperBuilder withColumns(Collection<Property<?>> columns) {
        this.columns = columns;
        return this;
    }

    MockQueryWrapperBuilder withHavingQualifier(Expression havingQualifier) {
        this.havingQualifier = havingQualifier;
        return this;
    }

    MockQueryWrapperBuilder withSelect(Select<?> select) {
        this.mockSelect = select;
        return this;
    }

    MockQueryWrapperBuilder withNeedsResultSetMapping(boolean needsResultSetMapping) {
        this.needsResultSetMapping = needsResultSetMapping;
        return this;
    }

    TranslatableQueryWrapper build() {
        return new TranslatableQueryWrapper(){

            @Override
            public boolean isDistinct() {
                return MockQueryWrapperBuilder.this.distinct;
            }

            @Override
            public QueryMetadata getMetaData(EntityResolver resolver) {
                return MockQueryWrapperBuilder.this.metaData != null ? MockQueryWrapperBuilder.this.metaData : new MockQueryMetadata();
            }

            @Override
            public Expression getQualifier() {
                return MockQueryWrapperBuilder.this.qualifier;
            }

            @Override
            public Collection<Ordering> getOrderings() {
                return MockQueryWrapperBuilder.this.orderings;
            }

            @Override
            public Collection<Property<?>> getColumns() {
                return MockQueryWrapperBuilder.this.columns;
            }

            @Override
            public Expression getHavingQualifier() {
                return MockQueryWrapperBuilder.this.havingQualifier;
            }

            @Override
            public Select<?> unwrap() {
                return MockQueryWrapperBuilder.this.mockSelect;
            }

            @Override
            public boolean needsResultSetMapping() {
                return MockQueryWrapperBuilder.this.needsResultSetMapping;
            }
        };
    }
}

